/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.plugin.extractor.openie;

import edu.knowitall.openie.Argument;
import edu.knowitall.openie.Instance;
import edu.knowitall.openie.OpenIE;
import edu.knowitall.tool.parse.ClearParser;
import edu.knowitall.tool.parse.DependencyParser;
import edu.knowitall.tool.postag.ClearPostagger;
import edu.knowitall.tool.postag.Postagger;
import edu.knowitall.tool.srl.ClearSrl;
import edu.knowitall.tool.srl.Srl;
import edu.knowitall.tool.tokenize.ClearTokenizer;
import edu.knowitall.tool.tokenize.Tokenizer;
import java.io.IOException;
import java.util.List;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.any23.extractor.ExtractionContext;
import org.apache.any23.extractor.ExtractionException;
import org.apache.any23.extractor.ExtractionParameters;
import org.apache.any23.extractor.ExtractionResult;
import org.apache.any23.extractor.Extractor;
import org.apache.any23.extractor.ExtractorDescription;
import org.apache.any23.extractor.IssueReport;
import org.apache.any23.plugin.Author;
import org.apache.any23.plugin.extractor.openie.OpenIEExtractorFactory;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.util.StreamUtils;
import org.apache.tika.Tika;
import org.apache.tika.exception.TikaException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import scala.collection.JavaConversions;
import scala.collection.Seq;

@Author(name="Lewis John McGibbney (lewismc@apache.org)")
public class OpenIEExtractor
implements Extractor.TagSoupDOMExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(OpenIEExtractor.class);

    public ExtractorDescription getDescription() {
        return OpenIEExtractorFactory.getDescriptionInstance();
    }

    public void run(ExtractionParameters extractionParameters, ExtractionContext context, Document in, ExtractionResult out) throws IOException, ExtractionException {
        String thresholdString;
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        runtime.gc();
        long usedMemory = Math.max(0L, runtime.totalMemory() - runtime.freeMemory());
        long availableMemory = maxMemory - usedMemory;
        if (availableMemory < 0x100000000L) {
            out.notifyIssue(IssueReport.IssueLevel.FATAL, "Not enough heap space available to perform OpenIE extraction: " + availableMemory / 0x100000L + "/" + maxMemory / 0x100000L + " MB. Requires 4096 MB.", -1L, -1L);
            LOG.error("Increase JVM heap size when running OpenIE extractor. max=" + maxMemory + "; available=" + availableMemory);
            return;
        }
        IRI documentIRI = context.getDocumentIRI();
        RDFUtils.iri((String)(documentIRI.toString() + "root"));
        out.writeNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        out.writeNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        LOG.debug("Processing: {}", (Object)documentIRI.toString());
        OpenIE openIE = new OpenIE((DependencyParser)new ClearParser((Postagger)new ClearPostagger((Tokenizer)new ClearTokenizer())), (Srl)new ClearSrl(), false, false);
        Seq extractions = null;
        Tika tika = new Tika();
        try {
            extractions = openIE.extract(tika.parseToString(StreamUtils.documentToInputStream((Document)in)));
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError e) {
            LOG.error("Encountered error during OpenIE extraction.", e);
        }
        catch (TikaException e) {
            LOG.error("Encountered error whilst parsing InputStream with Tika.", (Throwable)e);
        }
        List listExtractions = JavaConversions.seqAsJavaList((Seq)extractions);
        try {
            thresholdString = extractionParameters.getProperty("any23.extraction.openie.confidence.threshold");
        }
        catch (RuntimeException e) {
            thresholdString = null;
        }
        double threshold = thresholdString == null ? 0.5 : Double.parseDouble(thresholdString);
        for (Instance instance : listExtractions) {
            if (!(instance.confidence() > threshold)) continue;
            List listArg2s = JavaConversions.seqAsJavaList((Seq)instance.extr().arg2s());
            for (Argument argument : listArg2s) {
                Resource subject = RDFUtils.makeIRI((String)instance.extr().arg1().text(), (IRI)documentIRI);
                IRI predicate = (IRI)RDFUtils.makeIRI((String)instance.extr().rel().text(), (IRI)documentIRI);
                Value object = RDFUtils.toValue((String)argument.text());
                out.writeTriple(subject, predicate, object);
            }
        }
    }
}

