/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.cli;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.any23.Any23OnlineTestBase;
import org.apache.any23.cli.ToolRunner;
import org.apache.any23.rdf.RDFUtils;
import org.apache.any23.util.FileUtils;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlerTest
extends Any23OnlineTestBase {
    public static final Logger logger = LoggerFactory.getLogger(CrawlerTest.class);

    @Test
    public void testCLI() throws IOException, RDFHandlerException, RDFParseException {
        File outFile;
        block3: {
            CrawlerTest.assumeOnlineAllowed();
            outFile = File.createTempFile("crawler-test", ".nq", this.tempDirectory);
            outFile.delete();
            logger.info("Outfile: " + outFile.getAbsolutePath());
            Future<?> future = Executors.newSingleThreadExecutor().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ToolRunner.main((String[])String.format("crawler -f nquads --maxpages 50 --maxdepth 1 --politenessdelay 500 -o %s http://any23.apache.org", outFile.getAbsolutePath()).split(" "));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            try {
                future.get(10L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (e instanceof TimeoutException) break block3;
                e.printStackTrace();
            }
        }
        Assert.assertTrue((String)"The output file has not been created.", (boolean)outFile.exists());
        String[] lines = FileUtils.readFileLines((File)outFile);
        StringBuilder allLinesExceptLast = new StringBuilder();
        for (int i = 0; i < lines.length - 1; ++i) {
            allLinesExceptLast.append(lines[i]);
            allLinesExceptLast.append("\n");
        }
        Statement[] statements = RDFUtils.parseRDF((RDFFormat)RDFFormat.NQUADS, (String)allLinesExceptLast.toString());
        Assert.assertTrue((statements.length > 0 ? 1 : 0) != 0);
    }
}

