/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.plugin.crawler;

import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.crawler.CrawlController;
import edu.uci.ics.crawler4j.crawler.WebCrawler;
import edu.uci.ics.crawler4j.fetcher.PageFetcher;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtConfig;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtServer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.any23.plugin.crawler.CrawlerListener;
import org.apache.any23.plugin.crawler.DefaultWebCrawler;
import org.apache.any23.plugin.crawler.SharedData;

public class SiteCrawler {
    public static final String DEFAULT_PAGE_FILTER_RE = ".*(\\.(css|js|bmp|gif|jpe?g|png|tiff?|mid|mp2|mp3|mp4|wav|wma|avi|mov|mpeg|ram|m4v|wmv|rm|smil|pdf|swf|zip|rar|gz|xml|txt))$";
    public static final int DEFAULT_NUM_OF_CRAWLERS = 10;
    public static final Class<? extends WebCrawler> DEFAULT_WEB_CRAWLER = DefaultWebCrawler.class;
    public final Pattern defaultFilters = Pattern.compile(".*(\\.(css|js|bmp|gif|jpe?g|png|tiff?|mid|mp2|mp3|mp4|wav|wma|avi|mov|mpeg|ram|m4v|wmv|rm|smil|pdf|swf|zip|rar|gz|xml|txt))$");
    private final CrawlController controller;
    private final List<CrawlerListener> listeners = new ArrayList<CrawlerListener>();
    private int numOfCrawlers = 10;
    private Class<? extends WebCrawler> webCrawler = DEFAULT_WEB_CRAWLER;
    private final CrawlConfig crawlConfig;
    private ExecutorService service;

    public SiteCrawler(File storageFolder) {
        try {
            this.crawlConfig = new CrawlConfig();
            this.crawlConfig.setCrawlStorageFolder(storageFolder.getAbsolutePath());
            this.crawlConfig.setUserAgentString("Apache Any23 Web Crawler");
            PageFetcher pageFetcher = new PageFetcher(this.crawlConfig);
            RobotstxtConfig robotstxtConfig = new RobotstxtConfig();
            RobotstxtServer robotstxtServer = new RobotstxtServer(robotstxtConfig, pageFetcher);
            this.controller = new CrawlController(this.crawlConfig, pageFetcher, robotstxtServer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error while initializing crawler controller.", e);
        }
    }

    public int getNumOfCrawlers() {
        return this.numOfCrawlers;
    }

    public void setNumOfCrawlers(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Invalid number of crawlers, must be > 0 .");
        }
        this.numOfCrawlers = n;
    }

    public Class<? extends WebCrawler> getWebCrawler() {
        return this.webCrawler;
    }

    public void setWebCrawler(Class<? extends WebCrawler> c) {
        if (c == null) {
            throw new NullPointerException("c cannot be null.");
        }
        this.webCrawler = c;
    }

    public int getMaxDepth() {
        return this.crawlConfig.getMaxDepthOfCrawling();
    }

    public void setMaxDepth(int maxDepth) {
        if (maxDepth < -1 || maxDepth == 0) {
            throw new IllegalArgumentException("Invalid maxDepth, must be -1 or > 0");
        }
        this.crawlConfig.setMaxDepthOfCrawling(maxDepth);
    }

    public int getMaxPages() {
        return this.crawlConfig.getMaxPagesToFetch();
    }

    public void setMaxPages(int maxPages) {
        if (maxPages < -1 || maxPages == 0) {
            throw new IllegalArgumentException("Invalid maxPages, must be -1 or > 0");
        }
        this.crawlConfig.setMaxPagesToFetch(maxPages);
    }

    public int getPolitenessDelay() {
        return this.crawlConfig.getPolitenessDelay();
    }

    public void setPolitenessDelay(int millis) {
        if (millis >= 0) {
            this.crawlConfig.setPolitenessDelay(millis);
        }
    }

    public void addListener(CrawlerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CrawlerListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void start(URL seed, Pattern filters, boolean wait) throws Exception {
        SharedData.setCrawlData(seed.toExternalForm(), filters, Collections.synchronizedList(this.listeners));
        this.controller.addSeed(seed.toExternalForm());
        Runnable internalRunnable = new Runnable(){

            @Override
            public void run() {
                SiteCrawler.this.controller.start(SiteCrawler.this.getWebCrawler(), SiteCrawler.this.getNumOfCrawlers());
            }
        };
        if (wait) {
            internalRunnable.run();
        } else {
            if (this.service != null) {
                throw new IllegalStateException("Another service seems to run.");
            }
            this.service = Executors.newSingleThreadExecutor();
            this.service.execute(internalRunnable);
        }
    }

    public void start(URL seed, boolean wait) throws Exception {
        this.start(seed, this.defaultFilters, wait);
    }

    public synchronized void stop() {
        this.service.shutdownNow();
    }
}

