/*
 * Decompiled with CFR 0.152.
 */
package org.apache.any23.plugin.crawler;

import edu.uci.ics.crawler4j.crawler.Page;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.any23.Any23OnlineTestBase;
import org.apache.any23.plugin.crawler.CrawlerListener;
import org.apache.any23.plugin.crawler.SiteCrawler;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteCrawlerTest
extends Any23OnlineTestBase {
    public static final Logger logger = LoggerFactory.getLogger(SiteCrawlerTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSiteCrawling() throws Exception {
        SiteCrawlerTest.assumeOnlineAllowed();
        File tmpFile = File.createTempFile("site-crawler-test", ".storage");
        tmpFile.delete();
        SiteCrawler controller = new SiteCrawler(tmpFile);
        controller.setMaxPages(100);
        logger.info("Crawler4j: Setting max num of pages to: " + controller.getMaxPages());
        controller.setPolitenessDelay(500);
        logger.info("Crawler4j: Setting Politeness delay to: " + controller.getPolitenessDelay() + "ms");
        final HashSet distinctPages = new HashSet();
        controller.addListener(new CrawlerListener(){

            public void visitedPage(Page page) {
                distinctPages.add(page.getWebURL().getURL());
                Iterator it = distinctPages.iterator();
                while (it.hasNext()) {
                    logger.info("Crawler4j: Fetching page - " + (String)it.next());
                }
            }
        });
        controller.start(new URL("http://any23.apache.org/"), false);
        SiteCrawlerTest siteCrawlerTest = this;
        synchronized (siteCrawlerTest) {
            ((Object)((Object)this)).wait(15000L);
        }
        controller.stop();
        logger.info("Distinct pages: " + distinctPages.size());
        Assert.assertTrue((String)"Expected some page crawled.", (distinctPages.size() > 0 ? 1 : 0) != 0);
    }
}

