/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.ext.dynamicreg.server.validator;

import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.utils.OAuthUtils;
import org.apache.amber.oauth2.common.validators.AbstractValidator;
import org.apache.amber.oauth2.ext.dynamicreg.server.request.JSONHttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushPullValidator
extends AbstractValidator<JSONHttpServletRequestWrapper> {
    private Logger log = LoggerFactory.getLogger(PushPullValidator.class);

    public void validateContentType(JSONHttpServletRequestWrapper request) throws OAuthProblemException {
        String contentType = request.getContentType();
        String expectedContentType = "application/json";
        if (!OAuthUtils.hasContentType((String)contentType, (String)"application/json")) {
            throw OAuthUtils.handleBadContentTypeException((String)"application/json");
        }
        this.initializeValidationParameter(request);
    }

    private void initializeValidationParameter(JSONHttpServletRequestWrapper request) throws OAuthProblemException {
        String requestType = request.getParameter("type");
        if (OAuthUtils.isEmpty((String)requestType)) {
            throw OAuthUtils.handleOAuthProblemException((String)"Missing [type] parameter value");
        }
        if ("pull".equals(requestType)) {
            this.requiredParams.add("type");
            this.requiredParams.add("client_url");
        } else if ("push".equals(requestType)) {
            this.requiredParams.add("type");
            this.requiredParams.add("client_name");
            this.requiredParams.add("client_url");
            this.requiredParams.add("client_description");
            this.requiredParams.add("redirect_url");
        } else {
            throw OAuthUtils.handleOAuthProblemException((String)"Invalid [type] parameter value");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("OAuth dynamic client registration type is: {}", (Object[])new String[]{requestType});
        }
    }
}

