/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.ext.dynamicreg.server.request;

import javax.servlet.http.HttpServletRequest;
import org.apache.amber.oauth2.as.request.OAuthRequest;
import org.apache.amber.oauth2.common.exception.OAuthProblemException;
import org.apache.amber.oauth2.common.exception.OAuthSystemException;
import org.apache.amber.oauth2.common.validators.OAuthValidator;
import org.apache.amber.oauth2.ext.dynamicreg.server.request.JSONHttpServletRequestWrapper;
import org.apache.amber.oauth2.ext.dynamicreg.server.validator.PushPullValidator;

public class OAuthServerRegistrationRequest
extends OAuthRequest {
    private String type;
    private boolean isDiscovered;

    public OAuthServerRegistrationRequest(JSONHttpServletRequestWrapper request) throws OAuthSystemException, OAuthProblemException {
        this(request, false);
    }

    public OAuthServerRegistrationRequest(JSONHttpServletRequestWrapper request, boolean discover) throws OAuthSystemException, OAuthProblemException {
        super((HttpServletRequest)request);
        if (discover) {
            this.discover();
        }
    }

    protected OAuthValidator initValidator() throws OAuthProblemException, OAuthSystemException {
        return new PushPullValidator();
    }

    public void discover() throws OAuthSystemException {
        if ("pull".equals(this.type)) {
            // empty if block
        }
        this.isDiscovered = true;
    }

    public String getType() {
        return this.getParam("type");
    }

    public String getClientName() {
        return this.getParam("client_name");
    }

    public String getClientUrl() {
        return this.getParam("client_url");
    }

    public String getClientDescription() {
        return this.getParam("client_description");
    }

    public String getClientIcon() {
        return this.getParam("client_icon");
    }

    public String getRedirectURI() {
        return this.getParam("redirect_url");
    }

    public boolean isDiscovered() {
        return this.isDiscovered;
    }
}

