/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amber.oauth2.ext.dynamicreg.server.request;

import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.amber.oauth2.common.exception.OAuthRuntimeException;
import org.apache.amber.oauth2.common.utils.OAuthUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Logger log = LoggerFactory.getLogger(JSONHttpServletRequestWrapper.class);
    private JSONObject body;
    private boolean bodyRead = false;

    public JSONHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterMap().get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        try {
            this.readJsonBody();
            HashMap<String, String[]> parameters = new HashMap<String, String[]>();
            if (this.body != null) {
                JSONArray attributeNames = this.body.names();
                for (int i = 0; i < attributeNames.length(); ++i) {
                    String attributeName = attributeNames.getString(i);
                    String attributeValue = this.body.getString(attributeName);
                    parameters.put(attributeName, new String[]{attributeValue});
                }
            }
            return Collections.unmodifiableMap(parameters);
        }
        catch (JSONException e) {
            this.log.error("Dynamic client registration error: ", (Throwable)e);
            throw new OAuthRuntimeException("OAuth server error");
        }
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    private void readJsonBody() {
        if (!this.bodyRead) {
            this.bodyRead = true;
            try {
                ServletRequest request = this.getRequest();
                String contentType = request.getContentType();
                String expectedContentType = "application/json";
                if (!OAuthUtils.hasContentType((String)contentType, (String)"application/json")) {
                    return;
                }
                ServletInputStream inputStream = request.getInputStream();
                if (inputStream == null) {
                    return;
                }
                String jsonString = OAuthUtils.saveStreamAsString((InputStream)inputStream);
                this.body = new JSONObject(jsonString);
            }
            catch (JSONException e) {
                this.log.error("Cannot decode request body as a JSON: ", (Throwable)e);
            }
            catch (Exception e) {
                this.log.error("Dynamic client registration error: ", (Throwable)e);
                throw new OAuthRuntimeException("OAuth server error");
            }
        }
    }
}

