/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.messenger;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.stream.XMLStreamException;
import org.apache.airavata.wsmg.broker.AdditionalMessageContent;
import org.apache.airavata.wsmg.broker.ConsumerInfo;
import org.apache.airavata.wsmg.commons.CommonRoutines;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.messenger.ConsumerUrlManager;
import org.apache.airavata.wsmg.messenger.Deliverable;
import org.apache.airavata.wsmg.messenger.protocol.DeliveryProtocol;
import org.apache.airavata.wsmg.messenger.protocol.SendingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.addressing.EndpointReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderUtils
implements Deliverable {
    private static final Logger logger = LoggerFactory.getLogger(SenderUtils.class);
    private static OMFactory factory = OMAbstractFactory.getOMFactory();
    private ConsumerUrlManager urlManager;
    private DeliveryProtocol protocol;

    public SenderUtils(ConsumerUrlManager urlMan) {
        this.urlManager = urlMan;
    }

    @Override
    public void setProtocol(DeliveryProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void send(ConsumerInfo consumerInfo, OMElement notificationMessageBodyEl, AdditionalMessageContent additionalMessageContent) {
        if (consumerInfo.isPaused()) {
            return;
        }
        if (notificationMessageBodyEl == null) {
            logger.info("notification message is null, IGNORED");
            return;
        }
        if (this.urlManager.isUnavailable(consumerInfo.getConsumerEprStr())) {
            logger.info("consumer url is unavailable: " + consumerInfo.getConsumerEprStr());
            return;
        }
        EndpointReference consumerReference = new EndpointReference(consumerInfo.getConsumerEprStr());
        OMElement message = null;
        message = consumerInfo.getType().compareTo("wsnt") == 0 ? (consumerInfo.isUseNotify() ? this.wrapRawMessageToWsntWrappedFormat(notificationMessageBodyEl, additionalMessageContent) : notificationMessageBodyEl) : notificationMessageBodyEl;
        long timeElapsed = -1L;
        long startTime = -1L;
        startTime = System.currentTimeMillis();
        try {
            this.protocol.deliver(consumerInfo, message, additionalMessageContent);
            long finishTime = System.currentTimeMillis();
            timeElapsed = finishTime - startTime;
            this.urlManager.onSucessfullDelivery(consumerReference, timeElapsed);
        }
        catch (SendingException ex) {
            long finishTime = System.currentTimeMillis();
            timeElapsed = finishTime - startTime;
            this.urlManager.onFailedDelivery(consumerReference, finishTime, timeElapsed, ex, additionalMessageContent);
        }
    }

    public OMElement wrapRawMessageToWsntWrappedFormat(OMElement rawNotif, AdditionalMessageContent additionalMessageContent) {
        String producerReferenceElString;
        OMElement fullNotif = factory.createOMElement("Notify", NameSpaceConstants.WSNT_NS);
        OMElement notificationMessageEl = factory.createOMElement("NotificationMessage", NameSpaceConstants.WSNT_NS, (OMContainer)fullNotif);
        String topicElString = additionalMessageContent.getTopicElement();
        if (topicElString != null) {
            OMElement topicEl = null;
            try {
                topicEl = CommonRoutines.reader2OMElement((Reader)new StringReader(topicElString));
            }
            catch (XMLStreamException e) {
                logger.error("XMLStreamreader exception when setting topicEl", (Throwable)e);
            }
            notificationMessageEl.addChild((OMNode)topicEl);
        }
        if ((producerReferenceElString = additionalMessageContent.getProducerReference()) != null) {
            OMElement producerReferenceEl = null;
            try {
                producerReferenceEl = CommonRoutines.reader2OMElement((Reader)new StringReader(producerReferenceElString));
            }
            catch (XMLStreamException e) {
                logger.error("XMLStreamException at creating producerReferenceEl", (Throwable)e);
            }
            notificationMessageEl.addChild((OMNode)producerReferenceEl);
        }
        OMElement messageEl = factory.createOMElement("Message", NameSpaceConstants.WSNT_NS, (OMContainer)notificationMessageEl);
        messageEl.addChild((OMNode)rawNotif);
        return fullNotif;
    }
}

