/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.wseventing;

import org.apache.airavata.wsmg.broker.AbstractBrokerMsgReceiver;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.broker.wseventing.WSEProcessingContextBuilder;
import org.apache.airavata.wsmg.config.WsmgConfigurationContext;
import org.apache.airavata.wsmg.util.WsEventingOperations;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSEventingMsgReceiver
extends AbstractBrokerMsgReceiver {
    private static final Logger log = LoggerFactory.getLogger(WSEventingMsgReceiver.class);
    WSEProcessingContextBuilder builder = new WSEProcessingContextBuilder();

    @Override
    public MessageContext process(MessageContext inMsg, String operationName) throws AxisFault {
        WsEventingOperations msgType = WsEventingOperations.valueFrom(operationName);
        ProcessingContext processingContext = this.builder.build(inMsg, msgType);
        MessageContext outputMsg = null;
        log.debug("WS-Eventing: " + (Object)((Object)msgType));
        switch (msgType) {
            case SUBSCRIBE: {
                WsmgConfigurationContext brokerConfigContext = (WsmgConfigurationContext)inMsg.getConfigurationContext().getProperty("broker.wsmgconfig");
                brokerConfigContext.getSubscriptionManager().subscribe(processingContext);
                outputMsg = this.createOutputMessageContext(inMsg, processingContext);
                break;
            }
            case UNSUBSCRIBE: {
                WsmgConfigurationContext brokerConfigContext = (WsmgConfigurationContext)inMsg.getConfigurationContext().getProperty("broker.wsmgconfig");
                brokerConfigContext.getSubscriptionManager().unsubscribe(processingContext);
                outputMsg = this.createOutputMessageContext(inMsg, processingContext);
                break;
            }
            default: {
                throw new AxisFault("unsupported operation" + msgType.toString());
            }
        }
        return outputMsg;
    }
}

