/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.subscription;

import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionManager;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.apache.airavata.wsmg.commons.CommonRoutines;
import org.apache.axis2.AxisFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanUpThread
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CleanUpThread.class);
    private SubscriptionManager subMan;

    public CleanUpThread(SubscriptionManager manager) {
        this.subMan = manager;
    }

    @Override
    public void run() {
        logger.debug("CleanUpThread started");
        String key = null;
        SubscriptionState subscription = null;
        Set<String> keySet = null;
        long expirationTime = 259200000L;
        long skipCheckInterval = 600000L;
        long checkupInterval = 300000L;
        int MAX_TRY = 3;
        logger.info("Starting Subscription Cleaning up Thread.");
        while (true) {
            long currentTime = System.currentTimeMillis();
            long expiredStartTime = 0L;
            expiredStartTime = currentTime - 259200000L;
            long availabilityCheckTime = 0L;
            availabilityCheckTime = currentTime - 600000L;
            keySet = this.subMan.getShallowSubscriptionsCopy().keySet();
            Iterator<String> iterator = keySet.iterator();
            while (iterator.hasNext()) {
                key = iterator.next();
                subscription = this.subMan.getShallowSubscriptionsCopy().get(key);
                if (subscription.isNeverExpire()) continue;
                long subscriptionCreationTime = subscription.getCreationTime();
                long lastAvailableTime = subscription.getLastAvailableTime();
                if (subscriptionCreationTime < expiredStartTime) {
                    try {
                        this.subMan.removeSubscription(key);
                    }
                    catch (AxisFault e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    logger.info("*****Deleted (expiration)" + key + "-->" + subscription.getConsumerIPAddressStr() + "##" + subscription.getLocalTopic());
                    logger.info("*****Deleted (expiration)" + key + "-->" + subscription.getConsumerIPAddressStr() + "##" + subscription.getLocalTopic());
                    continue;
                }
                if (lastAvailableTime >= availabilityCheckTime) continue;
                if (CommonRoutines.isAvailable((URI)subscription.getConsumerAddressURI())) {
                    subscription.setLastAvailableTime(currentTime);
                    if (subscription.getUnAvailableCounter() <= 0) continue;
                    subscription.resetUnAvailableCounter();
                    continue;
                }
                int counter = subscription.addUnAvailableCounter();
                if (counter <= MAX_TRY) continue;
                try {
                    this.subMan.removeSubscription(key);
                }
                catch (AxisFault e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                iterator.remove();
                logger.info("*****Deleted (unavailable)" + key + "-->" + subscription.getConsumerIPAddressStr() + "##" + subscription.getLocalTopic());
                logger.info("*****Deleted (unavailable)" + key + "-->" + subscription.getConsumerIPAddressStr() + "##" + subscription.getLocalTopic());
            }
            try {
                Thread.sleep(300000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.error("thread was interrupped", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

