/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.util;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;

public class BrokerUtil {
    public static boolean sameStringValue(String x, String y) {
        return x == null && y == null || x != null && y != null && x.equals(y);
    }

    public static String getTopicLocalString(String filterText) {
        if (filterText == null) {
            throw new IllegalArgumentException("filter text can't be null");
        }
        String localName = null;
        int pos = filterText.indexOf(58);
        localName = pos != -1 ? filterText.substring(pos + 1) : filterText;
        return localName;
    }

    public static String getXPathString(OMElement xpathEl) throws AxisFault {
        if (xpathEl == null) {
            throw new IllegalArgumentException("xpath element can't be null");
        }
        OMAttribute dialectAttribute = xpathEl.getAttribute(new QName("Dialect"));
        if (dialectAttribute == null) {
            dialectAttribute = xpathEl.getAttribute(new QName("DIALECT"));
        }
        if (dialectAttribute == null) {
            throw new AxisFault("dialect is required for subscribe");
        }
        String dialectString = dialectAttribute.getAttributeValue();
        if (!dialectString.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
            throw new AxisFault("Unkown dialect: " + dialectString);
        }
        String xpathLocalString = xpathEl.getText();
        return xpathLocalString;
    }

    public static String getTopicFromRequestPath(String topicPath) {
        if (topicPath == null) {
            return null;
        }
        if (topicPath.length() == 0) {
            return null;
        }
        if (topicPath.startsWith("/") && (topicPath = topicPath.substring(1)).length() == 0) {
            return null;
        }
        String ret = null;
        int index = topicPath.indexOf("topic/");
        if (index >= 0 && (ret = topicPath.substring(index + "topic/".length())).length() == 0) {
            ret = null;
        }
        return ret;
    }
}

