/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.matching.simpleTopic;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.airavata.wsmg.broker.AdditionalMessageContent;
import org.apache.airavata.wsmg.broker.ConsumerInfo;
import org.apache.airavata.wsmg.broker.ConsumerList;
import org.apache.airavata.wsmg.broker.ConsumerListManager;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.apache.airavata.wsmg.matching.AbstractMessageMatcher;
import org.apache.airavata.wsmg.messenger.OutGoingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectWsntMessageMatcher
extends AbstractMessageMatcher {
    private static final Logger logger = LoggerFactory.getLogger(DirectWsntMessageMatcher.class);
    private ConsumerListManager consumerListmanager = new ConsumerListManager();
    private OutGoingQueue outGoingQueue = null;

    @Override
    public void start(String carrierLocation) {
        this.currentMessageCache = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSubscribe(SubscriptionState subscribeRequest, String subscriptionId) {
        String topicExpression = subscribeRequest.getLocalTopic();
        if (topicExpression == null || topicExpression.length() == 0) {
            logger.error("ERROR:WsntAdapterConnection creation failed.");
            return;
        }
        this.writeLockUnlockConsumers(true);
        try {
            this.consumerListmanager.addToConsumerList(topicExpression, subscribeRequest, subscriptionId);
            if (this.outGoingQueue == null) {
                this.outGoingQueue = subscribeRequest.getOutGoingQueue();
            }
        }
        finally {
            this.writeLockUnlockConsumers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleUnsubscribe(String subscriptionId) {
        int ret = 0;
        this.writeLockUnlockConsumers(true);
        try {
            ret = this.consumerListmanager.removeFromConsumerList(subscriptionId, null);
        }
        finally {
            this.writeLockUnlockConsumers(false);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateMatches(String wsntMessageConverterClassName, AdditionalMessageContent additionalMessageContent, String message, String topic, List<ConsumerInfo> matchedConsumers) {
        assert (matchedConsumers != null);
        this.readLockUnlockConsumers(true);
        try {
            ArrayList<ConsumerInfo> wildCardConsumerInfoList;
            ConsumerList topicConsumerList = this.consumerListmanager.getConsumerListByToken(topic);
            ConsumerList wildcardConsumerList = this.consumerListmanager.getConsumerListByToken(">");
            if (topicConsumerList != null) {
                ArrayList<ConsumerInfo> list = topicConsumerList.getConsumerList();
                matchedConsumers.addAll(list);
            }
            if (wildcardConsumerList != null && (wildCardConsumerInfoList = wildcardConsumerList.getConsumerList()) != null) {
                matchedConsumers.addAll(wildCardConsumerInfoList);
            }
        }
        finally {
            this.readLockUnlockConsumers(false);
        }
    }
}

