/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.commons.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionEntry;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.apache.airavata.wsmg.commons.storage.WsmgQueue;
import org.apache.airavata.wsmg.commons.storage.WsmgStorage;

public class WsmgInMemoryStorage
implements WsmgStorage,
WsmgQueue {
    private LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();
    private Map<String, SubscriptionState> expirableSubscriptions = new ConcurrentHashMap<String, SubscriptionState>();
    private Map<String, SubscriptionState> unexpirableSubscriptions = new ConcurrentHashMap<String, SubscriptionState>();

    @Override
    public void dispose() {
        this.queue.clear();
        this.expirableSubscriptions.clear();
        this.unexpirableSubscriptions.clear();
    }

    @Override
    public int insert(SubscriptionState subscription) {
        if (subscription.isNeverExpire()) {
            this.unexpirableSubscriptions.put(subscription.getId(), subscription);
        } else {
            this.expirableSubscriptions.put(subscription.getId(), subscription);
        }
        return 0;
    }

    @Override
    public int delete(String subscriptionId) {
        this.expirableSubscriptions.remove(subscriptionId);
        this.unexpirableSubscriptions.remove(subscriptionId);
        return 0;
    }

    @Override
    public List<SubscriptionEntry> getAllSubscription() {
        SubscriptionEntry se;
        ArrayList<SubscriptionEntry> ret = new ArrayList<SubscriptionEntry>(this.expirableSubscriptions.size() + this.unexpirableSubscriptions.size());
        Collection<SubscriptionState> entries = this.expirableSubscriptions.values();
        for (SubscriptionState s : entries) {
            se = new SubscriptionEntry();
            se.setSubscribeXml(s.getSubscribeXml());
            se.setSubscriptionId(s.getId());
            ret.add(se);
        }
        entries = this.unexpirableSubscriptions.values();
        for (SubscriptionState s : entries) {
            se = new SubscriptionEntry();
            se.setSubscribeXml(s.getSubscribeXml());
            se.setSubscriptionId(s.getId());
            ret.add(se);
        }
        return ret;
    }

    @Override
    public Object blockingDequeue() {
        Object obj = null;
        try {
            obj = this.queue.take();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException("interruped exception occured", ie);
        }
        return obj;
    }

    @Override
    public void cleanup() {
        this.queue.clear();
    }

    @Override
    public void enqueue(Object object, String trackId) {
        this.queue.offer(object);
    }
}

