/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.wseventing;

import org.apache.airavata.wsmg.broker.AbstractBrokerMsgReceiver;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.broker.wseventing.WSEProcessingContextBuilder;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.config.WsmgConfigurationContext;
import org.apache.airavata.wsmg.util.WsEventingOperations;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;

public class WSEventingPublishMsgReceiver
extends AbstractBrokerMsgReceiver {
    WSEProcessingContextBuilder builder = new WSEProcessingContextBuilder();

    @Override
    protected MessageContext process(MessageContext inMsgContext, String operationName) throws AxisFault {
        ProcessingContext processingContext = this.builder.build(inMsgContext, WsEventingOperations.PUBLISH);
        try {
            WsmgConfigurationContext brokerConfigContext = (WsmgConfigurationContext)inMsgContext.getConfigurationContext().getProperty("broker.wsmgconfig");
            brokerConfigContext.getNotificationProcessor().processMsg(processingContext, NameSpaceConstants.WSE_NS);
        }
        catch (Exception e) {
            throw new AxisFault("unable to process message", (Throwable)e);
        }
        return this.createOutputMessageContext(inMsgContext, processingContext);
    }

    @Override
    protected MessageContext createOutputMessageContext(MessageContext inMsg, ProcessingContext processingContext) throws AxisFault {
        MessageContext outputContext = null;
        OMElement responseMessage = processingContext.getRespMessage();
        if (responseMessage != null) {
            outputContext = super.createOutputMessageContext(inMsg, processingContext);
            String responseAction = String.format("%s/%s", NameSpaceConstants.WSE_NS.getNamespaceURI(), responseMessage.getLocalName());
            outputContext.setSoapAction(responseAction);
        }
        return outputContext;
    }
}

