/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.wseventing;

import java.util.Calendar;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.broker.context.ContextParameters;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.apache.airavata.wsmg.commons.CommonRoutines;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.messenger.OutGoingQueue;
import org.apache.airavata.wsmg.util.BrokerUtil;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSEProtocolSupport {
    private static final Logger log = LoggerFactory.getLogger(WSEProtocolSupport.class);

    public SubscriptionState createSubscriptionState(ProcessingContext ctx, OutGoingQueue outgoingQueue) throws AxisFault {
        boolean neverExpire = false;
        String topicLocalString = "";
        String xpathString = "";
        EndpointReference consumerReference = ctx.getContextParameter(ContextParameters.NOTIFY_TO_EPR);
        if (consumerReference == null) {
            throw new AxisFault("Only Push delivery Mode (NotifyTo) is supported in WSE");
        }
        String expireTimeString = ctx.getContextParameter(ContextParameters.SUBSCRIBER_EXPIRES);
        if (expireTimeString == null) {
            neverExpire = true;
        } else {
            long expireTime = Long.valueOf(expireTimeString);
            if (expireTime < 0L) {
                neverExpire = true;
            }
        }
        OMElement filterEl = ctx.getContextParameter(ContextParameters.FILTER_ELEMENT);
        if (filterEl == null) {
            topicLocalString = ctx.getContextParameter(ContextParameters.TOPIC_FROM_URL);
            if (topicLocalString == null) {
                topicLocalString = ">";
            }
            log.debug("got topicLocalString=" + topicLocalString);
        } else {
            String filterDialectAttrib = filterEl.getAttributeValue(new QName(null, "Dialect"));
            if (filterDialectAttrib.compareTo("http://www.ibm.com/xmlns/stdwip/web-services/WS-Topics/TopicExpression/simple") == 0) {
                topicLocalString = BrokerUtil.getTopicLocalString(filterEl.getText());
                if (topicLocalString == null) {
                    throw new AxisFault("topic is not given in the subscription");
                }
            } else if (filterDialectAttrib.compareTo("http://www.w3.org/TR/1999/REC-xpath-19991116") == 0) {
                topicLocalString = ctx.getContextParameter(ContextParameters.TOPIC_FROM_URL);
                xpathString = filterEl.getText();
                log.debug("got topicLocalString=" + topicLocalString + " xpathString=" + xpathString);
                if (xpathString == null) {
                    throw new AxisFault("xpath expression is not given");
                }
            } else if (filterDialectAttrib.compareTo("http://docs.oasis-open.org/wsn") == 0) {
                OMElement xpathEl;
                OMElement topicEl = filterEl.getFirstChildWithName(new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "TopicExpression"));
                if (topicEl != null) {
                    topicLocalString = BrokerUtil.getTopicLocalString(topicEl.getText());
                }
                if ((xpathEl = filterEl.getFirstChildWithName(new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "MessageContent"))) != null && (xpathString = xpathEl.getText()) == null && topicLocalString == null) {
                    throw new AxisFault("Both topic string and XPath String are null!");
                }
            } else {
                throw new AxisFault("Unkown dialect: ");
            }
        }
        if (topicLocalString == null || topicLocalString.length() == 0) {
            topicLocalString = ">";
        }
        SubscriptionState state = new SubscriptionState(consumerReference, true, false, topicLocalString, xpathString, "wse", outgoingQueue);
        state.setNeverExpire(neverExpire);
        return state;
    }

    public void createSubscribeResponse(ProcessingContext ctx, String subId) throws AxisFault {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        ctx.addResponseMsgNameSpaces(NameSpaceConstants.WSE_NS);
        OMElement responseMessage = factory.createOMElement("SubscribeResponse", NameSpaceConstants.WSE_NS);
        OMElement identifier = factory.createOMElement("Identifier", responseMessage.getNamespace());
        identifier.setText(subId);
        EndpointReference serviceLocationEndpointReference = new EndpointReference(ctx.getMessageContext().getAxisService().getEndpointURL());
        serviceLocationEndpointReference.addReferenceParameter(identifier);
        OMElement expiresEl = factory.createOMElement("Expires", responseMessage.getNamespace(), (OMContainer)responseMessage);
        Date expiration = this.getFutureExpirationDate();
        String dateString = CommonRoutines.getXsdDateTime((Date)expiration);
        expiresEl.setText(dateString);
        OMElement subscriptionManagerEpr = null;
        try {
            subscriptionManagerEpr = EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)serviceLocationEndpointReference, (QName)new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "SubscriptionManager"), (String)NameSpaceConstants.WSA_NS.getNamespaceURI());
            responseMessage.addChild((OMNode)subscriptionManagerEpr);
            subscriptionManagerEpr.setNamespace(responseMessage.getNamespace());
        }
        catch (AxisFault e) {
            log.error("unable to resolve EPR from OM", (Throwable)e);
            throw e;
        }
        ctx.setRespMessage(responseMessage);
    }

    private Date getFutureExpirationDate() {
        Calendar cal = Calendar.getInstance();
        Date currentDate = new Date();
        cal.setTime(currentDate);
        cal.add(5, 30);
        Date expiration = cal.getTime();
        return expiration;
    }
}

