/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.messenger.strategy.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.airavata.wsmg.broker.AdditionalMessageContent;
import org.apache.airavata.wsmg.broker.ConsumerInfo;
import org.apache.airavata.wsmg.commons.CommonRoutines;
import org.apache.airavata.wsmg.commons.OutGoingMessage;
import org.apache.airavata.wsmg.messenger.Deliverable;
import org.apache.airavata.wsmg.messenger.strategy.SendingStrategy;
import org.apache.axiom.om.OMElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialSender
implements SendingStrategy {
    private static final Logger log = LoggerFactory.getLogger(SerialSender.class);

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void addMessageToSend(OutGoingMessage outMessage, Deliverable deliverable) {
        this.sendNotification(outMessage, deliverable);
    }

    public void sendNotification(OutGoingMessage outGoingMessage, Deliverable deliverable) {
        if (outGoingMessage == null) {
            log.error("Got a null outgoing message");
            return;
        }
        String messageString = outGoingMessage.getTextMessage();
        List<ConsumerInfo> consumerInfoList = outGoingMessage.getConsumerInfoList();
        AdditionalMessageContent soapHeader = outGoingMessage.getAdditionalMessageContent();
        try {
            OMElement messgae2Send = CommonRoutines.reader2OMElement((Reader)new StringReader(messageString));
            for (ConsumerInfo obj : consumerInfoList) {
                deliverable.send(obj, messgae2Send, soapHeader);
            }
        }
        catch (XMLStreamException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

