/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.messenger.protocol.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.airavata.wsmg.broker.AdditionalMessageContent;
import org.apache.airavata.wsmg.broker.ConsumerInfo;
import org.apache.airavata.wsmg.commons.CommonRoutines;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.messenger.protocol.DeliveryProtocol;
import org.apache.airavata.wsmg.messenger.protocol.SendingException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Axis2Protocol
implements DeliveryProtocol {
    private static final Logger logger = LoggerFactory.getLogger(Axis2Protocol.class);
    private static SOAPFactory soapfactory = OMAbstractFactory.getSOAP11Factory();
    private ServiceClient nonThreadLocalServiceClient;
    long tcpConnectionTimeout;

    @Override
    public void deliver(ConsumerInfo consumerInfo, OMElement message, AdditionalMessageContent additionalMessageContent) throws SendingException {
        EndpointReference consumerReference = new EndpointReference(consumerInfo.getConsumerEprStr());
        String actionString = null;
        LinkedList<OMElement> soapHeaders = new LinkedList<OMElement>();
        if (consumerInfo.getType().compareTo("wsnt") == 0) {
            actionString = NameSpaceConstants.WSNT_NS.getNamespaceURI() + "/Notify";
        } else {
            actionString = additionalMessageContent.getAction();
            String topicElString = additionalMessageContent.getTopicElement();
            if (topicElString != null) {
                OMElement topicEl = null;
                try {
                    topicEl = CommonRoutines.reader2OMElement((Reader)new StringReader(topicElString));
                    soapHeaders.add(topicEl);
                }
                catch (XMLStreamException e) {
                    logger.error("exception at topicEl xmlStreamException", (Throwable)e);
                }
            }
        }
        ServiceClient client = null;
        try {
            client = this.configureServiceClient(actionString, consumerReference, additionalMessageContent.getMessageID(), soapHeaders);
            client.sendRobust(message);
        }
        catch (AxisFault ex) {
            throw new SendingException(ex.getCause());
        }
        finally {
            if (client != null) {
                try {
                    client.cleanup();
                    client.cleanupTransport();
                }
                catch (AxisFault ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.tcpConnectionTimeout = timeout;
    }

    private ServiceClient configureServiceClient(String action, EndpointReference consumerLocation, String msgId, List<OMElement> soapHeaders) throws AxisFault {
        ServiceClient client = this.getServiceClient();
        SOAPHeaderBlock msgIdEl = soapfactory.createSOAPHeaderBlock("MessageID", NameSpaceConstants.WSA_NS);
        msgIdEl.setText(msgId);
        SOAPHeaderBlock actionEl = soapfactory.createSOAPHeaderBlock("Action", NameSpaceConstants.WSA_NS);
        actionEl.setText(action);
        SOAPHeaderBlock to = soapfactory.createSOAPHeaderBlock("To", NameSpaceConstants.WSA_NS);
        to.setText(consumerLocation.getAddress());
        client.addHeader(actionEl);
        client.addHeader(msgIdEl);
        client.addHeader(to);
        for (OMElement omHeader : soapHeaders) {
            try {
                SOAPHeaderBlock headerBlock = ElementHelper.toSOAPHeaderBlock((OMElement)omHeader, (SOAPFactory)soapfactory);
                client.addHeader(headerBlock);
            }
            catch (Exception e) {
                throw AxisFault.makeFault((Throwable)e);
            }
        }
        Options opts = new Options();
        opts.setTimeOutInMilliSeconds(this.tcpConnectionTimeout);
        opts.setMessageId(msgId);
        opts.setTo(consumerLocation);
        opts.setAction(action);
        opts.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        opts.setProperty("__HTTP_PROTOCOL_VERSION__", (Object)"HTTP/1.0");
        client.setOptions(opts);
        return client;
    }

    private ServiceClient getServiceClient() throws AxisFault {
        if (this.nonThreadLocalServiceClient == null) {
            this.nonThreadLocalServiceClient = new ServiceClient();
        }
        this.nonThreadLocalServiceClient.removeHeaders();
        return this.nonThreadLocalServiceClient;
    }
}

