/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.commons.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.util.BrokerUtil;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMElementComparator {
    private static final Logger log = LoggerFactory.getLogger(OMElementComparator.class);
    private static List<String> ignorableNamespaceList = new ArrayList<String>();

    private OMElementComparator() {
    }

    public void addIgnorableNamespace(String nsURI) {
        ignorableNamespaceList.add(nsURI);
    }

    public void clearIgnorableNamespaces() {
        ignorableNamespaceList.clear();
    }

    public static boolean compare(OMElement elementOne, OMElement elementTwo) {
        if (OMElementComparator.isIgnorable(elementOne) || OMElementComparator.isIgnorable(elementTwo)) {
            return true;
        }
        if (elementOne == null && elementTwo == null) {
            log.debug("Both Elements are null.");
            return true;
        }
        if (elementOne == null || elementTwo == null) {
            log.debug("One of item to compare is null");
            return false;
        }
        return BrokerUtil.sameStringValue(elementOne.getLocalName(), elementTwo.getLocalName()) && OMElementComparator.compare(elementOne.getNamespace(), elementTwo.getNamespace()) && OMElementComparator.compareAttibutes(elementOne, elementTwo) && BrokerUtil.sameStringValue(elementOne.getText().trim(), elementTwo.getText().trim()) && OMElementComparator.compareChildren(elementOne, elementTwo);
    }

    private static boolean isIgnorable(OMElement elt) {
        if (elt != null) {
            OMNamespace namespace = elt.getNamespace();
            if (namespace != null) {
                return ignorableNamespaceList.contains(namespace.getNamespaceURI());
            }
            return false;
        }
        return false;
    }

    private static boolean compareChildren(OMElement elementOne, OMElement elementTwo) {
        OMElement elementTwoChild;
        HashMap<QName, OMElement> map = new HashMap<QName, OMElement>();
        Iterator oneIter = elementOne.getChildElements();
        while (oneIter.hasNext()) {
            OMElement elementOneChild = (OMElement)oneIter.next();
            if (!OMElementComparator.compare(elementOneChild, elementTwoChild = elementTwo.getFirstChildWithName(elementOneChild.getQName()))) {
                return false;
            }
            map.put(elementOneChild.getQName(), elementOneChild);
        }
        Iterator twoIter = elementTwo.getChildElements();
        while (twoIter.hasNext()) {
            elementTwoChild = (OMElement)twoIter.next();
            if (OMElementComparator.isIgnorable(elementTwoChild) || map.containsKey(elementTwoChild.getQName())) continue;
            return false;
        }
        return true;
    }

    private static boolean compareAttibutes(OMElement elementOne, OMElement elementTwo) {
        int elementOneAtribCount = 0;
        int elementTwoAtribCount = 0;
        Iterator oneIter = elementOne.getAllAttributes();
        while (oneIter.hasNext()) {
            OMAttribute omAttribute = (OMAttribute)oneIter.next();
            OMAttribute attr = elementTwo.getAttribute(omAttribute.getQName());
            if (attr == null) {
                log.debug("Attribute " + omAttribute + " is not found in both elements.");
                return false;
            }
            ++elementOneAtribCount;
        }
        Iterator elementTwoIter = elementTwo.getAllAttributes();
        while (elementTwoIter.hasNext()) {
            elementTwoIter.next();
            ++elementTwoAtribCount;
        }
        log.debug("Number of Attributes are equal? : " + (elementOneAtribCount == elementTwoAtribCount));
        return elementOneAtribCount == elementTwoAtribCount;
    }

    private static boolean compare(OMNamespace x, OMNamespace y) {
        log.debug("Compare namespace:" + x + " with " + y);
        return x == null && y == null || x != null && y != null && BrokerUtil.sameStringValue(x.getNamespaceURI(), y.getNamespaceURI());
    }
}

