/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.wseventing;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.broker.context.ContextParameters;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.broker.context.ProcessingContextBuilder;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.util.BrokerUtil;
import org.apache.airavata.wsmg.util.WsEventingOperations;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.context.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSEProcessingContextBuilder
extends ProcessingContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(WSEProcessingContextBuilder.class);

    @Override
    public ProcessingContext build(OMElement elem) {
        ProcessingContext processingContext = new ProcessingContext();
        if (elem != null && elem.getLocalName().equals("Subscribe")) {
            logger.debug("found subscribe element");
            this.onSubscription(processingContext, elem);
        }
        return processingContext;
    }

    public ProcessingContext build(SOAPEnvelope elem) {
        ProcessingContext context = null;
        SOAPBody soapBody = elem.getBody();
        context = soapBody != null ? this.build(soapBody.getFirstElement()) : this.build((OMElement)null);
        context.setEnvelope(elem);
        this.extractInfoFromHeader(context, elem.getHeader());
        return context;
    }

    public ProcessingContext build(MessageContext msgContext, WsEventingOperations operation) {
        ProcessingContext processingContext = new ProcessingContext();
        switch (operation) {
            case SUBSCRIBE: {
                Iterator iterator = msgContext.getEnvelope().getBody().getChildrenWithName(new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "Subscribe"));
                if (!iterator.hasNext()) {
                    throw new RuntimeException("invalid subscription message - no subscribe element");
                }
                this.onSubscription(processingContext, (OMElement)iterator.next());
            }
        }
        processingContext.setMessageConext(msgContext);
        processingContext.setEnvelope(msgContext.getEnvelope());
        this.extractInfoFromHeader(processingContext, msgContext.getEnvelope().getHeader());
        String topicFromUrl = BrokerUtil.getTopicFromRequestPath(msgContext.getTo().getAddress());
        processingContext.setContextParameter(ContextParameters.TOPIC_FROM_URL, topicFromUrl);
        return processingContext;
    }

    private void onSubscription(ProcessingContext processingContext, OMElement subscribeElement) {
        processingContext.setContextParameter(ContextParameters.SUBSCRIBE_ELEMENT, subscribeElement);
        Iterator iterator = subscribeElement.getChildrenWithName(new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "Expires"));
        if (iterator.hasNext()) {
            processingContext.setContextParameter(ContextParameters.SUBSCRIBER_EXPIRES, ((OMElement)iterator.next()).getText());
        }
        if (!(iterator = subscribeElement.getChildrenWithName(new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "Filter"))).hasNext()) {
            throw new RuntimeException("invalid subscription - unable to find filter dialet");
        }
        processingContext.setContextParameter(ContextParameters.FILTER_ELEMENT, iterator.next());
        iterator = subscribeElement.getChildrenWithName(new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "Delivery"));
        if (!iterator.hasNext()) {
            throw new RuntimeException("invalid subscription - unable to find delivery tag");
        }
        OMElement delivery = (OMElement)iterator.next();
        if (!(iterator = delivery.getChildrenWithName(new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "NotifyTo"))).hasNext()) {
            throw new RuntimeException("invalid subscription - unable to find NotifyTo tag");
        }
        OMElement notifyToElement = (OMElement)iterator.next();
        processingContext.setContextParameter(ContextParameters.NOTIFY_TO_ELEMENT, notifyToElement);
        try {
            processingContext.setContextParameter(ContextParameters.NOTIFY_TO_EPR, EndpointReferenceHelper.fromOM((OMElement)notifyToElement));
        }
        catch (AxisFault e) {
            throw new RuntimeException("invalid subscription - unable to parse notify to end point reference", e);
        }
    }

    private void extractInfoFromHeader(ProcessingContext context, SOAPHeader header) {
        Iterator ite = header.getChildrenWithName(new QName(NameSpaceConstants.WSE_NS.getNamespaceURI(), "Identifier"));
        if (ite.hasNext()) {
            OMElement identifier = (OMElement)ite.next();
            logger.debug("extracted identifier " + identifier.getText());
            context.setContextParameter(ContextParameters.SUB_ID, identifier.getText());
        }
    }
}

