/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.messenger.strategy.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.airavata.wsmg.commons.CommonRoutines;
import org.apache.airavata.wsmg.messenger.Deliverable;
import org.apache.airavata.wsmg.messenger.strategy.impl.FixedParallelSender;
import org.apache.airavata.wsmg.messenger.strategy.impl.LightweightMsg;
import org.apache.axiom.om.OMElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConsumerHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FixedParallelSender.class);
    protected LinkedBlockingQueue<LightweightMsg> queue = new LinkedBlockingQueue();
    private String consumerUrl;
    private Deliverable deliverable;

    public ConsumerHandler(String url, Deliverable deliverable) {
        this.consumerUrl = url;
        this.deliverable = deliverable;
    }

    public String getConsumerUrl() {
        return this.consumerUrl;
    }

    public void submitMessage(LightweightMsg msg) {
        try {
            this.queue.put(msg);
        }
        catch (InterruptedException e) {
            log.error("Interrupted when trying to add message");
        }
    }

    protected void send(List<LightweightMsg> list) {
        for (LightweightMsg m : list) {
            try {
                OMElement messgae2Send = CommonRoutines.reader2OMElement((Reader)new StringReader(m.getPayLoad()));
                this.deliverable.send(m.getConsumerInfo(), messgae2Send, m.getHeader());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

