/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.messenger;

import org.apache.airavata.wsmg.commons.OutGoingMessage;
import org.apache.airavata.wsmg.config.WSMGParameter;
import org.apache.airavata.wsmg.messenger.Deliverable;
import org.apache.airavata.wsmg.messenger.strategy.SendingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeliveryProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryProcessor.class);
    private SendingStrategy strategy;
    private Deliverable deliverable;
    private boolean running;
    private Thread t;

    public DeliveryProcessor(Deliverable deliverable, SendingStrategy strategy) {
        this.strategy = strategy;
        this.deliverable = deliverable;
    }

    public void start() {
        this.running = true;
        this.t = new Thread(new CheckingAndSending());
        this.t.start();
    }

    public void stop() {
        this.running = false;
        if (this.t != null) {
            this.t.interrupt();
            try {
                this.t.join();
            }
            catch (InterruptedException ie) {
                logger.error("Wait for sending thread to finish (join) is interrupted");
            }
        }
        WSMGParameter.OUT_GOING_QUEUE.dispose();
    }

    private class CheckingAndSending
    implements Runnable {
        private CheckingAndSending() {
        }

        @Override
        public void run() {
            DeliveryProcessor.this.strategy.init();
            while (DeliveryProcessor.this.running) {
                logger.debug("run - delivery thread");
                try {
                    OutGoingMessage outGoingMessage = (OutGoingMessage)WSMGParameter.OUT_GOING_QUEUE.blockingDequeue();
                    DeliveryProcessor.this.strategy.addMessageToSend(outGoingMessage, DeliveryProcessor.this.deliverable);
                }
                catch (Exception e) {
                    logger.warn("Unexpected_exception:");
                }
            }
            logger.debug("Shutdown Strategy");
            DeliveryProcessor.this.strategy.shutdown();
        }
    }
}

