/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.matching.XPath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.airavata.wsmg.broker.AdditionalMessageContent;
import org.apache.airavata.wsmg.broker.ConsumerInfo;
import org.apache.airavata.wsmg.broker.ConsumerList;
import org.apache.airavata.wsmg.broker.ConsumerListManager;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.apache.airavata.wsmg.matching.AbstractMessageMatcher;
import org.apache.airavata.wsmg.matching.XPath.YFilterInfo;
import org.apache.airavata.wsmg.messenger.OutGoingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YFilterMessageMatcher
extends AbstractMessageMatcher {
    private static final Logger logger = LoggerFactory.getLogger(YFilterMessageMatcher.class);
    private OutGoingQueue outGoingQueue = null;
    private HashMap<String, YFilterInfo> topicToYFilterInfo = new HashMap();
    private HashMap<String, String> subIdToTopic = new HashMap();
    private ConsumerListManager consumerListmanager = new ConsumerListManager();

    @Override
    public void start(String carrierLocation) {
        this.currentMessageCache = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateMatches(String wsntMessageConverterClassName, AdditionalMessageContent additionalMessageContent, String message, String topic, List<ConsumerInfo> matchedConsumers) {
        assert (matchedConsumers != null);
        this.readLockUnlockConsumers(true);
        try {
            List<ConsumerInfo> wildcardTopicAndXPathConsumerInfoList;
            List<ConsumerInfo> topicAndXPathConsumerInfoList;
            YFilterInfo yfilterInfo;
            ArrayList<ConsumerInfo> wildCardConsumerInfoList;
            ConsumerList wildcardConsumerList;
            ConsumerList topicConsumerList = this.consumerListmanager.getConsumerListByToken(topic);
            if (topicConsumerList != null) {
                ArrayList<ConsumerInfo> list = topicConsumerList.getConsumerList();
                matchedConsumers.addAll(list);
            }
            if ((wildcardConsumerList = this.consumerListmanager.getConsumerListByToken(">")) != null && (wildCardConsumerInfoList = wildcardConsumerList.getConsumerList()) != null) {
                matchedConsumers.addAll(wildCardConsumerInfoList);
            }
            if ((yfilterInfo = this.topicToYFilterInfo.get(topic)) != null && (topicAndXPathConsumerInfoList = yfilterInfo.getMatchingConsumerList(message)) != null) {
                matchedConsumers.addAll(topicAndXPathConsumerInfoList);
            }
            if ((yfilterInfo = this.topicToYFilterInfo.get(">")) != null && (wildcardTopicAndXPathConsumerInfoList = yfilterInfo.getMatchingConsumerList(message)) != null) {
                matchedConsumers.addAll(wildcardTopicAndXPathConsumerInfoList);
            }
        }
        finally {
            this.readLockUnlockConsumers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleUnsubscribe(String subscriptionId) {
        int ret = 1;
        this.writeLockUnlockConsumers(true);
        try {
            String topicExpression = this.subIdToTopic.get(subscriptionId);
            if (subscriptionId.startsWith("T")) {
                this.consumerListmanager.removeFromConsumerList(subscriptionId, topicExpression);
            } else {
                YFilterInfo yfilterInfo = this.topicToYFilterInfo.get(topicExpression);
                if (yfilterInfo != null) {
                    yfilterInfo.removeSubscription(subscriptionId);
                    if (yfilterInfo.getCounter() == 0) {
                        yfilterInfo = null;
                        this.topicToYFilterInfo.remove(topicExpression);
                    }
                } else {
                    System.out.println("ERROR: Cannot find subscription with the subId=" + subscriptionId);
                    ret = 0;
                }
            }
        }
        finally {
            this.writeLockUnlockConsumers(false);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSubscribe(SubscriptionState subscribeRequest, String subscriptionId) {
        this.writeLockUnlockConsumers(true);
        try {
            String topicExpression = subscribeRequest.getLocalTopic();
            this.subIdToTopic.put(subscriptionId, topicExpression);
            String xpathExpression = subscribeRequest.getXpathString();
            if (xpathExpression == null || xpathExpression.length() == 0) {
                this.consumerListmanager.addToConsumerList(topicExpression, subscribeRequest, subscriptionId);
            } else {
                YFilterInfo yfilterInfo = this.topicToYFilterInfo.get(topicExpression);
                if (yfilterInfo == null) {
                    yfilterInfo = new YFilterInfo();
                    this.topicToYFilterInfo.put(topicExpression, yfilterInfo);
                }
                yfilterInfo.addXPathQuery(xpathExpression, subscriptionId, subscribeRequest);
            }
            if (this.outGoingQueue == null) {
                this.outGoingQueue = subscribeRequest.getOutGoingQueue();
            }
        }
        finally {
            this.writeLockUnlockConsumers(false);
        }
    }
}

