/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.wsnotification;

import org.apache.airavata.wsmg.broker.AbstractBrokerMsgReceiver;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.broker.wsnotification.WSNotificationProcessingContextBuilder;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.config.WsmgConfigurationContext;
import org.apache.airavata.wsmg.util.WsNotificationOperations;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSNotificationMsgReceiver
extends AbstractBrokerMsgReceiver {
    private static final Logger log = LoggerFactory.getLogger(WSNotificationMsgReceiver.class);
    WSNotificationProcessingContextBuilder builder = new WSNotificationProcessingContextBuilder();

    @Override
    public MessageContext process(MessageContext inMsg, String operationName) throws AxisFault {
        WsNotificationOperations msgType = WsNotificationOperations.valueFrom(operationName);
        ProcessingContext processingContext = this.builder.build(inMsg, msgType);
        MessageContext outputMsg = null;
        switch (msgType) {
            case NOTIFY: {
                try {
                    WsmgConfigurationContext brokerConfigContext = (WsmgConfigurationContext)inMsg.getConfigurationContext().getProperty("broker.wsmgconfig");
                    brokerConfigContext.getNotificationProcessor().processMsg(processingContext, NameSpaceConstants.WSNT_NS);
                }
                catch (Exception e) {
                    throw new AxisFault("unable to process message", (Throwable)e);
                }
                outputMsg = this.createOutputMessageContext(inMsg, processingContext);
                break;
            }
            case SUBSCRIBE: {
                WsmgConfigurationContext brokerConfigContext = (WsmgConfigurationContext)inMsg.getConfigurationContext().getProperty("broker.wsmgconfig");
                brokerConfigContext.getSubscriptionManager().subscribe(processingContext);
                outputMsg = this.createOutputMessageContext(inMsg, processingContext);
                break;
            }
            case UNSUBSCRIBE: {
                WsmgConfigurationContext brokerConfigContext = (WsmgConfigurationContext)inMsg.getConfigurationContext().getProperty("broker.wsmgconfig");
                brokerConfigContext.getSubscriptionManager().unsubscribe(processingContext);
                outputMsg = this.createOutputMessageContext(inMsg, processingContext);
                break;
            }
            case RESUME_SUBSCRIPTION: {
                WsmgConfigurationContext brokerConfigContext = (WsmgConfigurationContext)inMsg.getConfigurationContext().getProperty("broker.wsmgconfig");
                brokerConfigContext.getSubscriptionManager().resumeSubscription(processingContext);
                outputMsg = this.createOutputMessageContext(inMsg, processingContext);
                break;
            }
            case PAUSE_SUBSCRIPTION: {
                WsmgConfigurationContext brokerConfigContext = (WsmgConfigurationContext)inMsg.getConfigurationContext().getProperty("broker.wsmgconfig");
                brokerConfigContext.getSubscriptionManager().pauseSubscription(processingContext);
                outputMsg = this.createOutputMessageContext(inMsg, processingContext);
                break;
            }
            default: {
                throw new AxisFault("not implemented yet");
            }
        }
        return outputMsg;
    }
}

