/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.handler;

import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingFaultsHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.dispatchers.AddressingBasedDispatcher;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.Phase;
import org.apache.axis2.util.JavaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedMessageHandler
extends AddressingBasedDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(PublishedMessageHandler.class);
    private static final String ADDRESSING_VALIDATE_ACTION = "addressing.validateAction";
    private AxisOperation publishOperation = null;
    private Phase addressingPhase = null;

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Handler.InvocationResponse response = Handler.InvocationResponse.CONTINUE;
        if (msgContext.getAxisService() == null || msgContext.getAxisOperation() == null) {
            boolean validateAction = JavaUtils.isTrue((Object)msgContext.getProperty(ADDRESSING_VALIDATE_ACTION), (boolean)true);
            msgContext.setProperty(ADDRESSING_VALIDATE_ACTION, (Object)false);
            response = super.invoke(msgContext);
            if (this.isForBrokerEventingService(msgContext)) {
                this.validateBrokerWSEventingOperation(msgContext);
            }
            if (validateAction) {
                this.checkAction(msgContext);
            }
            msgContext.setProperty(ADDRESSING_VALIDATE_ACTION, (Object)validateAction);
        }
        return response;
    }

    private void validateBrokerWSEventingOperation(MessageContext msgContext) {
        if (msgContext.getAxisOperation() == null) {
            AxisService service = msgContext.getAxisService();
            AxisOperation pubOperation = this.getPublishOperation(service);
            msgContext.setAxisOperation(pubOperation);
        }
    }

    private boolean isForBrokerEventingService(MessageContext msgContext) {
        return msgContext.getAxisService() != null && msgContext.getAxisService().getName().equals("EventingService");
    }

    private AxisOperation getPublishOperation(AxisService publisherService) {
        if (this.publishOperation == null) {
            this.publishOperation = publisherService.getOperationBySOAPAction("http://org.apache.airavata/WseNotification");
        }
        return this.publishOperation;
    }

    private Phase getAddressingPhase(MessageContext context) {
        if (this.addressingPhase == null) {
            List inFlowPhases = context.getConfigurationContext().getAxisConfiguration().getPhasesInfo().getINPhases();
            for (Phase p : inFlowPhases) {
                if (!p.getName().equalsIgnoreCase("Addressing")) continue;
                this.addressingPhase = p;
            }
        }
        return this.addressingPhase;
    }

    private void checkAction(MessageContext msgContext) throws AxisFault {
        Phase addPhase = this.getAddressingPhase(msgContext);
        if (addPhase == null) {
            logger.error("unable to locate addressing phase object");
        }
        if (msgContext != null && msgContext.getCurrentPhaseIndex() + 1 == addPhase.getHandlerCount() && (msgContext.getAxisService() == null || msgContext.getAxisOperation() == null)) {
            AddressingFaultsHelper.triggerActionNotSupportedFault((MessageContext)msgContext, (String)msgContext.getWSAAction());
        }
    }
}

