/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker;

import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.wsmg.broker.ConsumerList;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerListManager {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerListManager.class);
    protected Map<String, ConsumerList> token2ConsumerListMap = new HashMap<String, ConsumerList>();
    protected Map<String, String> subId2Token = new HashMap<String, String>();

    public void addToConsumerList(String token, SubscriptionState subscribeRequest, String subscriptionId) {
        ConsumerList consumerList = this.token2ConsumerListMap.get(token);
        if (consumerList == null) {
            consumerList = new ConsumerList();
            this.token2ConsumerListMap.put(token, consumerList);
        }
        consumerList.addConsumer(subscriptionId, subscribeRequest.getConsumerInfo());
        this.subId2Token.put(subscriptionId, token);
    }

    public String getTokenBySubscriptionId(String subscriptionId) {
        String token = this.subId2Token.get(subscriptionId);
        return token;
    }

    public int removeFromConsumerList(String subscriptionId, String token) {
        String tokenString = null;
        tokenString = token == null ? this.subId2Token.get(subscriptionId) : token;
        ConsumerList consumerList = this.token2ConsumerListMap.get(tokenString);
        if (consumerList == null) {
            logger.error("*****ERROR:Cannot find the token to delete: " + tokenString);
            return 0;
        }
        int result = consumerList.removeConsumer(subscriptionId);
        this.subId2Token.remove(subscriptionId);
        return result;
    }

    public ConsumerList getConsumerListByToken(String token) {
        ConsumerList consumerList = this.token2ConsumerListMap.get(token);
        return consumerList;
    }
}

