/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.util;

import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.airavata.wsmg.commons.CommonRoutines;
import org.apache.airavata.wsmg.commons.WsmgVersion;

public class RunTimeStatistics {
    public static long totalMessageSize = 0L;
    public static long totalReceivedNotification = 0L;
    public static long totalSentOutNotification = 0L;
    public static long totalFailedNotification = 0L;
    public static long totalSubscriptions = 0L;
    public static long totalSubscriptionsAtStartUp = 0L;
    public static long totalUnSubscriptions = 0L;
    public static long minMessageSize = Long.MAX_VALUE;
    public static long maxMessageSize = 0L;
    public static String startUpTime = "";
    public static long totalSuccessfulDeliveryTime = 0L;
    public static long totalFailedDeliveryTime = 0L;
    public static long minSuccessfulDeliveryTime = Long.MAX_VALUE;
    public static long maxSuccessfulDeliveryTime = 0L;
    public static long minFailedDeliveryTime = Long.MAX_VALUE;
    public static long maxFailedDeliveryTime = 0L;
    public static final HashMap<String, Integer> failConsumerList = new HashMap();
    private static long startUpTimeInMillis;

    public static synchronized void addNewNotificationMessageSize(int size) {
        if ((long)size < minMessageSize) {
            minMessageSize = size;
        }
        if ((long)size > maxMessageSize) {
            maxMessageSize = size;
        }
        totalMessageSize += (long)size;
        ++totalReceivedNotification;
    }

    public static synchronized void addNewSuccessfulDeliverTime(long deliveryTime) {
        if (deliveryTime < minSuccessfulDeliveryTime) {
            minSuccessfulDeliveryTime = deliveryTime;
        }
        if (deliveryTime > maxSuccessfulDeliveryTime) {
            maxSuccessfulDeliveryTime = deliveryTime;
        }
        totalSuccessfulDeliveryTime += deliveryTime;
        ++totalSentOutNotification;
    }

    public static synchronized void addNewFailedDeliverTime(long deliveryTime) {
        if (deliveryTime < minFailedDeliveryTime) {
            minFailedDeliveryTime = deliveryTime;
        }
        if (deliveryTime > maxFailedDeliveryTime) {
            maxFailedDeliveryTime = deliveryTime;
        }
        totalFailedDeliveryTime += deliveryTime;
        ++totalFailedNotification;
    }

    public static synchronized void addFailedConsumerURL(String url) {
        Integer previousCount = failConsumerList.get(url);
        if (previousCount == null) {
            failConsumerList.put(url, 1);
        } else {
            Integer n = previousCount;
            Integer n2 = previousCount = Integer.valueOf(previousCount + 1);
            failConsumerList.put(url, previousCount);
        }
    }

    public static void setStartUpTime() {
        Date currentDate = new Date();
        startUpTime = CommonRoutines.getXsdDateTime((Date)currentDate);
        startUpTimeInMillis = currentDate.getTime();
    }

    public static String getHtmlString() {
        String htmlString = "";
        htmlString = htmlString + "<p>Total incoming message number: <span class=\"xml-requests-count\">" + totalReceivedNotification + "</span><br />\n";
        htmlString = htmlString + "Total successful outgoing message number: " + totalSentOutNotification + "<br>\n";
        htmlString = htmlString + "Total unreachable outgoing message number: " + totalFailedNotification + "<br>\n";
        htmlString = htmlString + "Total subscriptions requested: " + totalSubscriptions + "(+" + totalSubscriptionsAtStartUp + " startUp)<br>\n";
        htmlString = htmlString + "Total Unsubscriptions requested: " + totalUnSubscriptions + "<br>\n";
        htmlString = htmlString + "</p>\n";
        int averageMessageSize = 0;
        if (totalReceivedNotification != 0L) {
            averageMessageSize = (int)(totalMessageSize / totalReceivedNotification);
        }
        htmlString = htmlString + "<p>Average message size: " + averageMessageSize + " bytes<br>\n";
        htmlString = htmlString + "Max message size: " + maxMessageSize + " bytes<br>\n";
        htmlString = htmlString + "Min message size: " + minMessageSize + " bytes<br>\n";
        htmlString = htmlString + "</p>\n";
        long averageSuccessfulDeliveryTime = 0L;
        if (totalSuccessfulDeliveryTime != 0L) {
            averageSuccessfulDeliveryTime = totalSuccessfulDeliveryTime / totalSentOutNotification;
        }
        htmlString = htmlString + "<p>Average Successful Delivery Time: " + averageSuccessfulDeliveryTime + " ms<br>\n";
        htmlString = htmlString + "Max Successful Delivery Time: " + maxSuccessfulDeliveryTime + " ms<br>\n";
        htmlString = htmlString + "Min Successful Delivery Time: " + minSuccessfulDeliveryTime + " ms<br>\n";
        htmlString = htmlString + "</p>\n";
        long averageFailedDeliveryTime = 0L;
        if (totalFailedDeliveryTime != 0L) {
            averageFailedDeliveryTime = totalFailedDeliveryTime / totalFailedNotification;
        }
        htmlString = htmlString + "<p>Average Unreachable Delivery Time: " + averageFailedDeliveryTime + " ms<br>\n";
        htmlString = htmlString + "Max Unreachable Delivery Time: " + maxFailedDeliveryTime + " ms<br>\n";
        htmlString = htmlString + "Min Unreachable Delivery Time: " + minFailedDeliveryTime + " ms<br>\n";
        htmlString = htmlString + "</p>\n";
        htmlString = htmlString + "<p>Service started at: " + startUpTime + " <span class=\"starttime-seconds\">" + startUpTimeInMillis + "</span> [seconds] since UNIX epoch)" + "<br />\n";
        htmlString = htmlString + "Version: <span class=\"service-name\">" + WsmgVersion.getImplementationVersion() + "</span></p>\n";
        htmlString = htmlString + "<p>Total unreachable consumerUrl: " + failConsumerList.size() + " <br>\n";
        TreeSet<String> consumerUrlList = new TreeSet<String>(failConsumerList.keySet());
        for (String url : consumerUrlList) {
            int failedCount = failConsumerList.get(url);
            htmlString = htmlString + "  " + url + " -->" + failedCount + " <br>\n";
        }
        htmlString = htmlString + "</p>\n";
        return htmlString;
    }
}

