/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.messenger;

import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.airavata.wsmg.broker.AdditionalMessageContent;
import org.apache.airavata.wsmg.commons.config.ConfigurationManager;
import org.apache.airavata.wsmg.util.RunTimeStatistics;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerUrlManager {
    private static final Logger logger = LoggerFactory.getLogger(ConsumerUrlManager.class);
    private ConcurrentHashMap<String, FailedConsumerInfo> failedConsumerUrls = new ConcurrentHashMap();
    private final int defaultMaxRetry;
    private long expireTimeGap;
    private Timer cleanupTimer;

    public ConsumerUrlManager(ConfigurationManager config) {
        this.defaultMaxRetry = config.getConfig("broker.msg.delivery.retries", 2);
        this.expireTimeGap = 60000L * config.getConfig("consumer.expiration.time.gap", 5L);
        long timerThreadInterval = Math.max(this.expireTimeGap / 5L, 60000L);
        this.cleanupTimer = new Timer("Failed consumer url handler", true);
        this.cleanupTimer.scheduleAtFixedRate((TimerTask)new URLCleanUpTask(), 0L, timerThreadInterval);
    }

    public void stop() {
        logger.info("Stop ConsumerUrlManager");
        if (this.cleanupTimer != null) {
            this.cleanupTimer.cancel();
        }
        logger.info("ConsumerUrlManager Stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailedDelivery(EndpointReference consumerEndpointReference, long timeFinished, long timeTaken, AxisFault exception, AdditionalMessageContent headers) {
        String url = consumerEndpointReference.getAddress();
        RunTimeStatistics.addNewFailedDeliverTime(timeTaken);
        RunTimeStatistics.addFailedConsumerURL(url);
        if (this.isEligibleToBlackList(exception)) {
            ConcurrentHashMap<String, FailedConsumerInfo> concurrentHashMap = this.failedConsumerUrls;
            synchronized (concurrentHashMap) {
                FailedConsumerInfo info = this.failedConsumerUrls.get(url);
                if (info == null) {
                    info = new FailedConsumerInfo();
                    this.failedConsumerUrls.put(url, info);
                }
                info.incrementNumberOfTimesTried(timeFinished + this.expireTimeGap);
            }
        } else {
            String errorMsg = String.format("unable to deliver message: [%s] to consumer: [%s], reason: [%s]", headers.toString(), url, exception.getMessage());
            logger.error(errorMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSucessfullDelivery(EndpointReference consumerEndpointReference, long timeTaken) {
        RunTimeStatistics.addNewSuccessfulDeliverTime(timeTaken);
        ConcurrentHashMap<String, FailedConsumerInfo> concurrentHashMap = this.failedConsumerUrls;
        synchronized (concurrentHashMap) {
            FailedConsumerInfo info = this.failedConsumerUrls.remove(consumerEndpointReference.getAddress());
            if (info != null) {
                logger.debug(String.format("message was delivered to previously %d times failed url : %s", info.getNumberOfTimesTried(), consumerEndpointReference.getAddress()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUnavailable(String url) {
        ConcurrentHashMap<String, FailedConsumerInfo> concurrentHashMap = this.failedConsumerUrls;
        synchronized (concurrentHashMap) {
            FailedConsumerInfo info = this.failedConsumerUrls.get(url);
            return info != null && info.isMaxRetryCountReached();
        }
    }

    private boolean isEligibleToBlackList(AxisFault f) {
        Throwable cause = f.getCause();
        if (cause == null) {
            logger.error("unknown error occured", cause);
            return false;
        }
        return cause instanceof SocketTimeoutException || cause.getMessage().indexOf("timed out") > 0 || cause instanceof NoRouteToHostException;
    }

    class URLCleanUpTask
    extends TimerTask {
        URLCleanUpTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug("starting to clean up black listed consumer urls");
            long currentTime = System.currentTimeMillis();
            ConcurrentHashMap concurrentHashMap = ConsumerUrlManager.this.failedConsumerUrls;
            synchronized (concurrentHashMap) {
                for (Map.Entry entry : ConsumerUrlManager.this.failedConsumerUrls.entrySet()) {
                    FailedConsumerInfo info = (FailedConsumerInfo)entry.getValue();
                    if (!info.isMaxRetryCountReached() || info.getLastAtteptExpiryTime() < currentTime) continue;
                    info.decrementNumberOfTimeTried();
                    logger.info("decrementing number of times tried for consumer url: " + (String)entry.getKey());
                }
            }
            logger.debug("finished cleaning black listed consumer urls");
        }
    }

    class FailedConsumerInfo {
        private int numberOfTimesTried;
        private long expiryTime;

        FailedConsumerInfo() {
        }

        public void incrementNumberOfTimesTried(long expireTime) {
            ++this.numberOfTimesTried;
            this.expiryTime = expireTime;
        }

        public void decrementNumberOfTimeTried() {
            --this.numberOfTimesTried;
        }

        public int getNumberOfTimesTried() {
            return this.numberOfTimesTried;
        }

        public boolean isMaxRetryCountReached() {
            return this.numberOfTimesTried >= ConsumerUrlManager.this.defaultMaxRetry;
        }

        public long getLastAtteptExpiryTime() {
            return this.expiryTime;
        }
    }
}

