/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.matching;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.airavata.wsmg.broker.AdditionalMessageContent;
import org.apache.airavata.wsmg.broker.ConsumerInfo;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;

public abstract class AbstractMessageMatcher {
    protected Map<String, String> currentMessageCache;
    private ReentrantReadWriteLock consumerListLock = new ReentrantReadWriteLock();

    public AbstractMessageMatcher() {
        this.currentMessageCache = new HashMap<String, String>();
    }

    public abstract void start(String var1);

    public abstract void populateMatches(String var1, AdditionalMessageContent var2, String var3, String var4, List<ConsumerInfo> var5);

    public abstract int handleUnsubscribe(String var1);

    public abstract void handleSubscribe(SubscriptionState var1, String var2);

    public String handleGetCurrentMessage(String topic) {
        String currentMessage = this.currentMessageCache.get(topic);
        return currentMessage;
    }

    public void readLockUnlockConsumers(boolean lock) {
        ReentrantReadWriteLock.ReadLock readlock = this.consumerListLock.readLock();
        this.lockUnlock(readlock, lock);
    }

    public void writeLockUnlockConsumers(boolean lock) {
        ReentrantReadWriteLock.WriteLock writeLock = this.consumerListLock.writeLock();
        this.lockUnlock(writeLock, lock);
    }

    private void lockUnlock(Lock l, boolean lock) {
        if (lock) {
            l.lock();
        } else {
            l.unlock();
        }
    }
}

