/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.commons.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionEntry;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.apache.airavata.wsmg.commons.storage.DatabaseCreator;
import org.apache.airavata.wsmg.commons.storage.JdbcStorage;
import org.apache.airavata.wsmg.commons.storage.WsmgQueue;
import org.apache.airavata.wsmg.commons.storage.WsmgStorage;
import org.apache.airavata.wsmg.util.Counter;
import org.apache.axiom.om.OMElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsmgPersistantStorage
implements WsmgStorage,
WsmgQueue {
    private static final Logger logger = LoggerFactory.getLogger(WsmgPersistantStorage.class);
    private static final String TABLE_NAME_TO_CHECK = "subscription";
    private Counter storeToDBCounter = new Counter();
    private JdbcStorage db;

    public WsmgPersistantStorage(String jdbcUrl, String jdbcDriver) {
        this.db = new JdbcStorage(jdbcUrl, jdbcDriver);
        Connection conn = null;
        try {
            conn = this.db.connect();
            if (!DatabaseCreator.isDatabaseStructureCreated((String)TABLE_NAME_TO_CHECK, (Connection)conn)) {
                DatabaseCreator.createMsgBrokerDatabase((Connection)conn);
                logger.info("New Database created for Message Broker");
            } else {
                logger.info("Database already created for Message Broker!");
            }
            this.initMessageQueueStorage();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Database failure");
        }
        finally {
            this.db.closeConnection(conn);
        }
    }

    @Override
    public void dispose() {
        if (this.db != null) {
            this.db.closeAllConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubscriptionEntry> getAllSubscription() {
        PreparedStatement stmt;
        Connection conn;
        ArrayList<SubscriptionEntry> ret;
        block17: {
            ret = new ArrayList<SubscriptionEntry>();
            conn = null;
            stmt = null;
            try {
                int size = this.db.countRow(TABLE_NAME_TO_CHECK, "*");
                conn = this.db.connect();
                stmt = conn.prepareStatement("SELECT * FROM subscription");
                ResultSet rs = stmt.executeQuery();
                ret.ensureCapacity(size);
                if (rs == null) break block17;
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                while (rs.next()) {
                    SubscriptionEntry subscriptionEntry = new SubscriptionEntry();
                    subscriptionEntry.setSubscriptionId(rs.getString("SubscriptionId"));
                    InputStream inStream = null;
                    try {
                        int nRead;
                        inStream = rs.getBinaryStream("content");
                        while ((nRead = inStream.read(buffer)) != -1) {
                            outStream.write(buffer, 0, nRead);
                        }
                        outStream.flush();
                        subscriptionEntry.setSubscribeXml(new String(outStream.toByteArray()));
                    }
                    catch (IOException ie) {
                        logger.error("Unable to read XML from database", (Throwable)ie);
                        continue;
                    }
                    finally {
                        outStream.reset();
                        if (inStream == null) continue;
                        try {
                            inStream.close();
                        }
                        catch (Exception e) {
                            logger.error("Cannot close database stream", (Throwable)e);
                        }
                        continue;
                    }
                    ret.add(subscriptionEntry);
                }
            }
            catch (SQLException ex) {
                try {
                    logger.error("sql exception occured", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    this.db.quietlyClose(conn, new Statement[]{stmt});
                    throw throwable;
                }
                this.db.quietlyClose(conn, new Statement[]{stmt});
            }
        }
        this.db.quietlyClose(conn, new Statement[]{stmt});
        return ret;
    }

    @Override
    public int insert(SubscriptionState subscription) {
        String address = subscription.getConsumerReference().getAddress();
        Map referenceParametersMap = subscription.getConsumerReference().getAllReferenceParameters();
        String consumerReferenceParameters = null;
        if (referenceParametersMap == null) {
            consumerReferenceParameters = "";
        } else {
            StringBuffer buffer = new StringBuffer();
            for (OMElement currentReferenceParameter : referenceParametersMap.values()) {
                try {
                    buffer.append(currentReferenceParameter.toStringWithConsume());
                }
                catch (XMLStreamException se) {
                    logger.error("unable to convert reference parameter", (Throwable)se);
                }
            }
            consumerReferenceParameters = buffer.toString();
        }
        int policyValue = 0;
        if (subscription.isWsrmPolicy()) {
            policyValue = 1;
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        int result = 0;
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.db.connect();
            stmt = connection.prepareStatement("INSERT INTO subscription(SubscriptionId, content, wsrm, Topics, XPath, ConsumerAddress, ReferenceProperties, CreationTime) VALUES( ? , ? , ? , ? , ? , ? , ? , ?)");
            stmt.setString(1, subscription.getId());
            stmt.setBinaryStream(2, (InputStream)new ByteArrayInputStream(subscription.getSubscribeXml().getBytes()), subscription.getSubscribeXml().getBytes().length);
            stmt.setInt(3, policyValue);
            stmt.setString(4, subscription.getLocalTopic());
            stmt.setString(5, subscription.getXpathString());
            stmt.setString(6, address);
            stmt.setBinaryStream(7, (InputStream)new ByteArrayInputStream(consumerReferenceParameters.getBytes()), consumerReferenceParameters.getBytes().length);
            stmt.setTimestamp(8, now);
            result = this.db.executeUpdateAndClose(stmt);
            this.db.commitAndFree(connection);
            this.storeToDBCounter.addCounter();
        }
        catch (SQLException ex) {
            logger.error("sql exception occured", (Throwable)ex);
            this.db.rollbackAndFree(connection);
        }
        return result;
    }

    @Override
    public int delete(String subscriptionId) {
        int result = 0;
        Connection connection = null;
        try {
            connection = this.db.connect();
            PreparedStatement stmt = connection.prepareStatement("DELETE FROM subscription WHERE SubscriptionId= ?");
            stmt.setString(1, subscriptionId);
            result = this.db.executeUpdateAndClose(stmt);
            this.db.commitAndFree(connection);
        }
        catch (SQLException sql) {
            this.db.rollbackAndFree(connection);
            logger.error("sql exception occured", (Throwable)sql);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.db.connect();
            stmt = conn.createStatement();
            this.batchCleanDB(stmt, conn);
        }
        catch (SQLException e) {
            try {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (this.db.isAutoCommit()) {
                    try {
                        conn.setAutoCommit(true);
                    }
                    catch (SQLException e2) {
                        logger.error(e2.getMessage(), (Throwable)e2);
                    }
                }
                this.db.quietlyClose(conn, new Statement[]{stmt});
                throw throwable;
            }
            if (this.db.isAutoCommit()) {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException e3) {
                    logger.error(e3.getMessage(), (Throwable)e3);
                }
            }
            this.db.quietlyClose(conn, new Statement[]{stmt});
        }
        if (this.db.isAutoCommit()) {
            try {
                conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.db.quietlyClose(conn, new Statement[]{stmt});
    }

    @Override
    public Object blockingDequeue() throws InterruptedException {
        while (true) {
            try {
                return this.retrive();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void enqueue(Object object, String trackId) {
        block15: {
            Connection connection = null;
            PreparedStatement stmt = null;
            PreparedStatement stmt2 = null;
            PreparedStatement stmt3 = null;
            connection = this.db.connect();
            this.lockMaxMinTables(connection);
            stmt = connection.prepareStatement(QueueContants.SQL_MAX_ID_SEPERATE_TABLE);
            ResultSet result = stmt.executeQuery();
            if (!result.next()) {
                throw new RuntimeException("MAX_ID Table is not init, redeploy the service !!!");
            }
            int nextkey = result.getInt(1);
            stmt2 = connection.prepareStatement(QueueContants.SQL_MAX_ID_INCREMENT + nextkey);
            stmt2.executeUpdate();
            stmt3 = connection.prepareStatement("INSERT INTO disQ (id, trackId, message, status) VALUES (?,?,?,0)");
            stmt3.setInt(1, nextkey);
            stmt3.setString(2, trackId);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(output);
            out.writeObject(object);
            byte[] buffer = output.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(buffer);
            stmt3.setBinaryStream(3, (InputStream)in, buffer.length);
            stmt3.executeUpdate();
            this.db.commit(connection);
            try {
                this.unLockTables(connection);
            }
            catch (SQLException sql) {
                logger.error("Cannot Unlock Table", (Throwable)sql);
            }
            this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3});
            break block15;
            catch (SQLException sqlEx) {
                this.db.rollback(connection);
                logger.error("unable to enque the message in persistant storage", (Throwable)sqlEx);
                try {
                    this.unLockTables(connection);
                }
                catch (SQLException sql) {
                    logger.error("Cannot Unlock Table", (Throwable)sql);
                }
                this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3});
            }
            catch (IOException ioEx) {
                this.db.rollback(connection);
                logger.error("unable to enque the message in persistant storage", (Throwable)ioEx);
                {
                    catch (Throwable throwable) {
                        try {
                            this.unLockTables(connection);
                        }
                        catch (SQLException sql) {
                            logger.error("Cannot Unlock Table", (Throwable)sql);
                        }
                        this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3});
                        throw throwable;
                    }
                }
                try {
                    this.unLockTables(connection);
                }
                catch (SQLException sql) {
                    logger.error("Cannot Unlock Table", (Throwable)sql);
                }
                this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initMessageQueueStorage() throws SQLException {
        Connection connection = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt2 = null;
        PreparedStatement stmt3 = null;
        PreparedStatement stmt4 = null;
        try {
            connection = this.db.connect();
            this.lockMaxMinTables(connection);
            stmt = connection.prepareStatement(QueueContants.SQL_MAX_ID_SEPERATE_TABLE);
            ResultSet result = stmt.executeQuery();
            if (!result.next()) {
                stmt2 = connection.prepareStatement(QueueContants.SQL_MAX_ID_INSERT);
                stmt2.executeUpdate();
            }
            if (!(result = (stmt3 = connection.prepareStatement(QueueContants.SQL_MIN_ID_SEPERATE_TABLE)).executeQuery()).next()) {
                stmt4 = connection.prepareStatement(QueueContants.SQL_MIN_ID_INSERT);
                stmt4.executeUpdate();
            }
            this.db.commit(connection);
        }
        catch (SQLException sqle) {
            try {
                this.db.rollback(connection);
                throw sqle;
            }
            catch (Throwable throwable) {
                try {
                    this.unLockTables(connection);
                }
                catch (SQLException sql) {
                    logger.error("Cannot Unlock Table", (Throwable)sql);
                }
                this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3, stmt4});
                throw throwable;
            }
        }
        try {
            this.unLockTables(connection);
        }
        catch (SQLException sql) {
            logger.error("Cannot Unlock Table", (Throwable)sql);
        }
        this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3, stmt4});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object retrive() throws SQLException, IOException, InterruptedException {
        long wait = 1000L;
        int nextkey = -1;
        int maxid = -2;
        Connection connection = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt2 = null;
        PreparedStatement stmt3 = null;
        ResultSet result = null;
        while (true) {
            block25: {
                block24: {
                    connection = this.db.connect();
                    this.lockMaxMinTables(connection);
                    stmt = connection.prepareStatement(QueueContants.SQL_MIN_ID_SEPERATE_TABLE);
                    result = stmt.executeQuery();
                    if (!result.next()) {
                        throw new RuntimeException("Queue init has failed earlier");
                    }
                    nextkey = result.getInt(1);
                    stmt2 = connection.prepareStatement(QueueContants.SQL_MAX_ID_SEPERATE_TABLE);
                    result = stmt2.executeQuery();
                    if (!result.next()) {
                        throw new RuntimeException("Queue init has failed earlier");
                    }
                    maxid = result.getInt(1);
                    if (maxid <= nextkey) break block24;
                    stmt3 = connection.prepareStatement(QueueContants.SQL_MIN_ID_INCREMENT + nextkey);
                    stmt3.executeUpdate();
                    logger.debug("Update MIN ID by one");
                    this.db.commit(connection);
                    try {
                        this.unLockTables(connection);
                    }
                    catch (SQLException sql) {
                        sql.printStackTrace();
                        logger.error("Cannot Unlock Table", (Throwable)sql);
                    }
                    break;
                }
                this.db.commit(connection);
                try {
                    this.unLockTables(connection);
                    break block25;
                }
                catch (SQLException sql) {
                    sql.printStackTrace();
                    logger.error("Cannot Unlock Table", (Throwable)sql);
                }
                break block25;
                catch (SQLException sql) {
                    try {
                        this.db.rollback(connection);
                        throw sql;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.unLockTables(connection);
                        }
                        catch (SQLException sql2) {
                            sql2.printStackTrace();
                            logger.error("Cannot Unlock Table", (Throwable)sql2);
                        }
                        this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3});
                        throw throwable;
                    }
                }
            }
            this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3});
            try {
                wait = Math.min(wait + 1000L, 5000L);
                logger.debug("Wait=" + wait);
                Thread.sleep(wait);
            }
            catch (InterruptedException e) {
                logger.warn("Queue is interrupted to close");
                throw e;
            }
        }
        this.db.quietlyClose(connection, new Statement[]{stmt, stmt2, stmt3});
        Object resultObj = null;
        int key = -1;
        try {
            connection = this.db.connect();
            stmt = connection.prepareStatement(QueueContants.SQL_SELECT_STATEMENT + nextkey);
            result = stmt.executeQuery();
            if (result.next()) {
                key = result.getInt(1);
                InputStream in = result.getAsciiStream(2);
                ObjectInputStream s = new ObjectInputStream(in);
                try {
                    resultObj = s.readObject();
                }
                catch (ClassNotFoundException e) {
                    logger.error("Cannot Deserialize Object from Database, ClassNotFound. ", (Throwable)e);
                }
            } else {
                throw new RuntimeException("MAX_ID and MIN_ID are inconsistent with subscription table, need to reset all data value");
            }
            try {
                String query = QueueContants.SQL_DELETE_STATEMENT + key;
                stmt2 = connection.prepareStatement(query);
                stmt2.executeUpdate();
                this.db.commit(connection);
            }
            catch (SQLException sqle) {
                this.db.rollback(connection);
                throw sqle;
            }
        }
        catch (Throwable throwable) {
            this.db.quietlyClose(connection, new Statement[]{stmt, stmt2});
            throw throwable;
        }
        this.db.quietlyClose(connection, new Statement[]{stmt, stmt2});
        return resultObj;
    }

    private void batchCleanDB(Statement stmt, Connection con) throws SQLException {
        DatabaseCreator.DatabaseType databaseType = DatabaseCreator.DatabaseType.other;
        int[] aiupdateCounts = new int[]{};
        boolean bError = false;
        try {
            con.setAutoCommit(false);
            stmt.clearBatch();
            int totalStatement = 0;
            try {
                databaseType = DatabaseCreator.getDatabaseType((Connection)con);
            }
            catch (Exception e) {
                logger.error("Error evaluating database type", (Throwable)e);
            }
            if (DatabaseCreator.DatabaseType.mysql.equals((Object)databaseType)) {
                stmt.addBatch("lock tables disQ write, MaxIDTable write, MinIDTable write;");
                ++totalStatement;
            } else if (DatabaseCreator.DatabaseType.derby.equals((Object)databaseType)) {
                stmt.addBatch("lock table disQ in exclusive mode;");
                ++totalStatement;
                stmt.addBatch("lock table MaxIDTable in exclusive mode;");
                ++totalStatement;
                stmt.addBatch("lock table MinIDTable in exclusive mode;");
                ++totalStatement;
            }
            stmt.addBatch("Delete from disQ;");
            ++totalStatement;
            stmt.addBatch("Delete from MaxIDTable;");
            ++totalStatement;
            stmt.addBatch("Delete from MinIDTable;");
            aiupdateCounts = new int[++totalStatement];
            aiupdateCounts = stmt.executeBatch();
        }
        catch (BatchUpdateException bue) {
            bError = true;
            aiupdateCounts = bue.getUpdateCounts();
            logger.error("SQLException: " + bue.getMessage());
            logger.error("SQLState:  " + bue.getSQLState());
            logger.error("Message:  " + bue.getMessage());
            logger.error("Vendor:  " + bue.getErrorCode());
            logger.info("Update counts:  ");
            for (int i = 0; i < aiupdateCounts.length; ++i) {
                logger.error(aiupdateCounts[i] + "   ");
            }
            for (SQLException SQLe = bue; SQLe != null; SQLe = SQLe.getNextException()) {
                logger.error(SQLe.getMessage(), (Throwable)SQLe);
            }
        }
        catch (SQLException SQLe) {
            bError = true;
            throw SQLe;
        }
        finally {
            for (int i = 0; !bError && i < aiupdateCounts.length; ++i) {
                int iProcessed = aiupdateCounts[i];
                if (iProcessed >= 0 || iProcessed == -2) continue;
                logger.info("Error batch." + iProcessed);
                bError = true;
            }
            if (bError) {
                con.rollback();
            } else {
                con.commit();
            }
            if (DatabaseCreator.DatabaseType.mysql.equals((Object)databaseType)) {
                CallableStatement prepareStmt = con.prepareCall("unlock tables;");
                this.db.executeUpdateAndClose((PreparedStatement)prepareStmt);
            }
        }
        logger.info("Queue is cleaned.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void lockMaxMinTables(Connection connection) throws SQLException {
        DatabaseCreator.DatabaseType databaseType = DatabaseCreator.DatabaseType.other;
        try {
            databaseType = DatabaseCreator.getDatabaseType((Connection)connection);
        }
        catch (Exception e) {
            logger.error("Error evaluating database type", (Throwable)e);
        }
        connection.setAutoCommit(false);
        String sql = null;
        Statement stmt = null;
        try {
            switch (databaseType) {
                case derby: {
                    sql = "LOCK TABLE MaxIDTable IN EXCLUSIVE MODE";
                    String sql2 = "LOCK TABLE MinIDTable IN EXCLUSIVE MODE";
                    stmt = connection.createStatement();
                    stmt.addBatch(sql);
                    stmt.addBatch(sql2);
                    stmt.executeBatch();
                    return;
                }
                case mysql: {
                    sql = "lock tables MaxIDTable write,MinIDTable write";
                    stmt = connection.createStatement();
                    stmt.executeQuery(sql);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        finally {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unLockTables(Connection connection) throws SQLException {
        DatabaseCreator.DatabaseType databaseType = DatabaseCreator.DatabaseType.other;
        try {
            databaseType = DatabaseCreator.getDatabaseType((Connection)connection);
        }
        catch (Exception e) {
            logger.error("Error evaluating database type", (Throwable)e);
        }
        try {
            switch (databaseType) {
                case derby: {
                    return;
                }
                case mysql: {
                    String sql = "unlock tables";
                    PreparedStatement stmt = null;
                    try {
                        stmt = connection.prepareStatement(sql);
                        stmt.executeQuery();
                        this.db.commit(connection);
                        return;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                default: {
                    return;
                }
            }
        }
        finally {
            if (this.db.isAutoCommit()) {
                connection.setAutoCommit(true);
            }
        }
    }

    private static class QueueContants {
        public static final int FINAL_WAIT_IN_MILI = 5000;
        public static final String TABLE_NAME = "disQ";
        public static final String TABLE_NAME_MAXID = "MaxIDTable";
        public static final String TABLE_NAME_MINID = "MinIDTable";
        public static final int STATUS_OPEN = 0;
        public static final String SQL_INSERT_STATEMENT = "INSERT INTO disQ (id, trackId, message, status) VALUES (?,?,?,0)";
        public static String SQL_DELETE_STATEMENT = "DELETE FROM disQ WHERE id=";
        public static String SQL_SELECT_STATEMENT = "SELECT id,message FROM disQ WHERE id=";
        public static String SQL_MAX_ID_SEPERATE_TABLE = "SELECT maxID FROM MaxIDTable";
        public static String SQL_MIN_ID_SEPERATE_TABLE = "SELECT minID FROM MinIDTable";
        public static String SQL_MAX_ID_INSERT = "INSERT INTO MaxIDTable (maxID) VALUES (1)";
        public static String SQL_MIN_ID_INSERT = "INSERT INTO MinIDTable (minID) VALUES (1)";
        public static String SQL_MAX_ID_INCREMENT = "UPDATE MaxIDTable SET maxID = maxID+1 WHERE maxID =";
        public static String SQL_MIN_ID_INCREMENT = "UPDATE MinIDTable SET minID = minID+1 WHERE minID =";

        private QueueContants() {
        }
    }

    private static class SubscriptionConstants {
        public static final String TABLE_NAME_EXPIRABLE_SUBCRIPTIONS = "subscription";
        public static final String TABLE_NAME_NON_EXPIRABLE_SUBCRIPTIONS = "specialSubscription";
        public static final String EXP_INSERT_SQL_QUERY = "INSERT INTO subscription(SubscriptionId, content, wsrm, Topics, XPath, ConsumerAddress, ReferenceProperties, CreationTime) VALUES( ? , ? , ? , ? , ? , ? , ? , ?)";
        public static final String EXP_DELETE_SQL_QUERY = "DELETE FROM subscription WHERE SubscriptionId= ?";
        public static final String EXP_SELECT_QUERY = "SELECT * FROM subscription";
        public static final String NONEXP_INSERT_SQL_QUERY = "INSERT INTO specialSubscription(SubscriptionId, content, wsrm, Topics, XPath, ConsumerAddress, ReferenceProperties, CreationTime) VALUES( ? , ? , ? , ? , ? , ? , ? , ?)";
        public static final String NONEXP_DELETE_SQL_QUERY = "DELETE FROM specialSubscription WHERE SubscriptionId= ?";
        public static final String NONEXP_SELECT_QUERY = "SELECT * FROM specialSubscription";

        private SubscriptionConstants() {
        }
    }
}

