/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.wsnotification;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.airavata.wsmg.broker.context.ContextParameters;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.messenger.OutGoingQueue;
import org.apache.airavata.wsmg.util.BrokerUtil;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSNTProtocolSupport {
    private static final Logger log = LoggerFactory.getLogger(WSNTProtocolSupport.class);

    public SubscriptionState createSubscriptionState(ProcessingContext ctx, OutGoingQueue outgoingQueue) throws AxisFault {
        OMElement xpathEl;
        OMElement topicExpressionEl;
        OMElement element;
        EndpointReference consumerReference = ctx.getContextParameter(ContextParameters.NOTIFY_TO_EPR);
        if (consumerReference == null) {
            throw new AxisFault("Only Push delivery Mode (NotifyTo) is supported");
        }
        boolean neverExpire = false;
        boolean useNotify = true;
        boolean wsrmEnabled = false;
        String topicLocalString = "";
        String xpathString = "";
        String expireTimeString = ctx.getContextParameter(ContextParameters.SUBSCRIBER_EXPIRES);
        if (expireTimeString == null) {
            neverExpire = true;
        } else {
            long expireTime = Long.valueOf(expireTimeString);
            if (expireTime < 0L) {
                neverExpire = true;
            }
        }
        OMElement useNotifyEl = ctx.getContextParameter(ContextParameters.USE_NOTIFY_ELEMENT);
        if (useNotifyEl != null) {
            String s = useNotifyEl.getText();
            useNotify = Boolean.valueOf(s);
        }
        if ((element = ctx.getContextParameter(ContextParameters.SUB_POLICY)) != null) {
            wsrmEnabled = true;
        }
        if ((topicExpressionEl = ctx.getContextParameter(ContextParameters.TOPIC_EXPRESSION_ELEMENT)) != null) {
            topicLocalString = BrokerUtil.getTopicLocalString(topicExpressionEl.getText());
        }
        if ((xpathEl = ctx.getContextParameter(ContextParameters.XPATH_ELEMENT)) != null) {
            xpathString = BrokerUtil.getXPathString(xpathEl);
        }
        if (xpathString == null && topicLocalString == null) {
            throw new AxisFault("Both topic string and XPath String are null!");
        }
        if (topicLocalString == null || topicLocalString.length() == 0) {
            topicLocalString = ">";
        }
        SubscriptionState state = new SubscriptionState(consumerReference, useNotify, wsrmEnabled, topicLocalString, xpathString, "wsnt", outgoingQueue);
        state.setNeverExpire(neverExpire);
        return state;
    }

    public void createSubscribeResponse(ProcessingContext ctx, String subId) throws AxisFault {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        ctx.addResponseMsgNameSpaces(NameSpaceConstants.WSNT_NS);
        OMElement responseMessage = factory.createOMElement("SubscribeResponse", NameSpaceConstants.WSNT_NS);
        OMElement identifier = factory.createOMElement("Identifier", responseMessage.getNamespace());
        identifier.setText(subId);
        EndpointReference serviceLocationEndpointReference = new EndpointReference(ctx.getMessageContext().getAxisService().getEndpointURL());
        serviceLocationEndpointReference.addReferenceParameter(identifier);
        OMElement subscriptionReference = null;
        try {
            subscriptionReference = EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)serviceLocationEndpointReference, (QName)new QName("SubscriptionReference"), (String)NameSpaceConstants.WSA_NS.getNamespaceURI());
            responseMessage.addChild((OMNode)subscriptionReference);
            subscriptionReference.setNamespace(responseMessage.getNamespace());
        }
        catch (AxisFault e) {
            log.error("unable to resolve EPR from OM", (Throwable)e);
            throw e;
        }
        ctx.setRespMessage(responseMessage);
    }

    public static class Client {
        public static OMElement createSubscriptionMsg(EndpointReference eventSinkLocation, String topicExpression, String xpathExpression) throws AxisFault {
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMElement message = factory.createOMElement("SubscribeRequest", NameSpaceConstants.WSNT_NS);
            if (topicExpression != null) {
                OMElement topicExpEl = factory.createOMElement("TopicExpression", NameSpaceConstants.WSNT_NS, (OMContainer)message);
                topicExpEl.addAttribute("Dialect", "http://www.ibm.com/xmlns/stdwip/web-services/WS-Topics/TopicExpression/simple", NameSpaceConstants.WSNT_NS);
                topicExpEl.declareNamespace(NameSpaceConstants.WIDGET_NS);
                topicExpEl.setText(NameSpaceConstants.WIDGET_NS.getPrefix() + ":" + topicExpression);
            }
            if (xpathExpression != null) {
                OMElement xpathExpEl = factory.createOMElement("Selector", NameSpaceConstants.WSNT_NS, (OMContainer)message);
                xpathExpEl.addAttribute("Dialect", "http://www.w3.org/TR/1999/REC-xpath-19991116", null);
                xpathExpEl.setText(xpathExpression);
            }
            OMElement useNotifyEl = factory.createOMElement("UseNotify", message.getNamespace(), (OMContainer)message);
            useNotifyEl.setText("true");
            OMElement eprCrEl = EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)eventSinkLocation, (QName)new QName("ConsumerReference"), (String)NameSpaceConstants.WSA_NS.getNamespaceURI());
            message.addChild((OMNode)eprCrEl);
            eprCrEl.setNamespace(message.getNamespace());
            return message;
        }

        public static String decodeSubscriptionResponse(OMElement subscriptionReference) throws AxisFault {
            String subscriptionId = null;
            EndpointReference subscriptionReferenceEPR = EndpointReferenceHelper.fromOM((OMElement)subscriptionReference);
            Map referenceParams = subscriptionReferenceEPR.getAllReferenceParameters();
            if (referenceParams != null) {
                QName identifierQName = new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "Identifier");
                OMElement identifierEl = (OMElement)referenceParams.get(identifierQName);
                subscriptionId = identifierEl != null ? identifierEl.getText() : null;
            }
            return subscriptionId;
        }

        public static OMElement createUnsubscribeMsg() {
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMElement message = factory.createOMElement("UnsubsribeRequest", NameSpaceConstants.WSNT_NS);
            return message;
        }

        public static OMElement encodeNotification(String topic, OMElement message, EndpointReference producerReference) throws AxisFault {
            OMFactory factory = OMAbstractFactory.getOMFactory();
            OMElement topicExpEl = factory.createOMElement("Topic", NameSpaceConstants.WSNT_NS);
            topicExpEl.addAttribute("Dialect", "http://www.ibm.com/xmlns/stdwip/web-services/WS-Topics/TopicExpression/simple", null);
            topicExpEl.declareNamespace(NameSpaceConstants.WIDGET_NS);
            topicExpEl.setText(NameSpaceConstants.WIDGET_NS.getPrefix() + ":" + topic);
            OMElement messageToNotify = factory.createOMElement("Notify", NameSpaceConstants.WSNT_NS);
            messageToNotify.declareNamespace(NameSpaceConstants.WSNT_NS);
            messageToNotify.declareNamespace(NameSpaceConstants.WSA_NS);
            OMElement notificationMesssageEl = factory.createOMElement("NotificationMessage", messageToNotify.getNamespace(), (OMContainer)messageToNotify);
            notificationMesssageEl.addChild((OMNode)topicExpEl);
            notificationMesssageEl.addChild((OMNode)EndpointReferenceHelper.toOM((OMFactory)factory, (EndpointReference)producerReference, (QName)new QName(notificationMesssageEl.getNamespace().getNamespaceURI(), "ProducerReference", notificationMesssageEl.getNamespace().getPrefix()), (String)NameSpaceConstants.WSA_NS.getNamespaceURI()));
            OMElement messageEl = factory.createOMElement("Message", notificationMesssageEl.getNamespace(), (OMContainer)notificationMesssageEl);
            messageEl.addChild((OMNode)message);
            return messageToNotify;
        }
    }
}

