/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.subscription;

import java.io.StringReader;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.airavata.wsmg.broker.context.ContextParameters;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.broker.context.ProcessingContextBuilder;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionEntry;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.apache.airavata.wsmg.broker.wseventing.WSEProcessingContextBuilder;
import org.apache.airavata.wsmg.broker.wseventing.WSEProtocolSupport;
import org.apache.airavata.wsmg.broker.wsnotification.WSNTProtocolSupport;
import org.apache.airavata.wsmg.broker.wsnotification.WSNotificationProcessingContextBuilder;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.airavata.wsmg.commons.WsmgCommonConstants;
import org.apache.airavata.wsmg.commons.storage.WsmgStorage;
import org.apache.airavata.wsmg.config.WsmgConfigurationContext;
import org.apache.airavata.wsmg.matching.AbstractMessageMatcher;
import org.apache.airavata.wsmg.messenger.OutGoingQueue;
import org.apache.airavata.wsmg.util.RunTimeStatistics;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionManager {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionManager.class);
    private HashMap<String, SubscriptionState> subscriptions = new HashMap();
    private ReentrantReadWriteLock subscriptionLock = new ReentrantReadWriteLock();
    private WSEProtocolSupport wseProtocalSupport = new WSEProtocolSupport();
    private WSNTProtocolSupport wsntProtocolSupport = new WSNTProtocolSupport();
    private WsmgStorage subscriptionDB;
    private WsmgConfigurationContext wsmgConfig;
    private OutGoingQueue outGoingQueue;
    private int counter = 1;

    public SubscriptionManager(WsmgConfigurationContext paramters, WsmgStorage storage) {
        this.init(paramters, storage);
    }

    private void init(WsmgConfigurationContext parameters, WsmgStorage storage) {
        this.wsmgConfig = parameters;
        this.subscriptionDB = storage;
        this.outGoingQueue = parameters.getOutgoingQueue();
        try {
            this.checkSubscriptionDB(storage);
        }
        catch (AxisFault e) {
            log.error("Subscription database has malformed subscriptions. Ignoring them.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractMap<String, SubscriptionState> getShallowSubscriptionsCopy() {
        HashMap<String, SubscriptionState> ret = null;
        this.readLockUnlockSubscriptions(true);
        try {
            ret = new HashMap<String, SubscriptionState>(this.subscriptions);
        }
        finally {
            this.readLockUnlockSubscriptions(false);
        }
        return ret;
    }

    public void subscribe(ProcessingContext ctx) throws AxisFault {
        String subId = this.createSubscription(null, ctx);
        if (subId == null) {
            log.error("ERROR: No subscription created");
            return;
        }
        if (NameSpaceConstants.WSE_NS.equals(ctx.getContextParameter(ContextParameters.SUBSCRIBE_ELEMENT).getNamespace())) {
            this.wseProtocalSupport.createSubscribeResponse(ctx, subId);
        } else {
            this.wsntProtocolSupport.createSubscribeResponse(ctx, subId);
        }
    }

    private String createSubscription(String subscriptionId, ProcessingContext ctx) throws AxisFault {
        SubscriptionState state = null;
        String key = null;
        state = NameSpaceConstants.WSE_NS.equals(ctx.getContextParameter(ContextParameters.SUBSCRIBE_ELEMENT).getNamespace()) ? this.wseProtocalSupport.createSubscriptionState(ctx, this.outGoingQueue) : this.wsntProtocolSupport.createSubscriptionState(ctx, this.outGoingQueue);
        if (subscriptionId == null) {
            key = this.checkSubscriptionExist(state);
            if (key != null) {
                return key;
            }
            state.setCreationTime(System.currentTimeMillis());
            key = this.generateSubscriptionId(state.getXpathString() != null && state.getXpathString().length() > 0);
        } else {
            key = subscriptionId;
        }
        for (AbstractMessageMatcher m : this.wsmgConfig.getMessageMatchers()) {
            m.handleSubscribe(state, key);
        }
        if (subscriptionId == null) {
            ++RunTimeStatistics.totalSubscriptions;
            try {
                String subscribeXml = ctx.getContextParameter(ContextParameters.SUBSCRIBE_ELEMENT).toStringWithConsume();
                state.setId(key);
                state.setSubscribeXml(subscribeXml);
                this.subscriptionDB.insert(state);
            }
            catch (Exception ex) {
                log.error("unable to insert subscription to database", (Throwable)ex);
                throw new AxisFault("unable to insert subscription to database ", (Throwable)ex);
            }
        }
        this.addToSubscriptionMap(key, state);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSubscriptionMap(String key, SubscriptionState state) {
        this.writeLockUnlockSubscription(true);
        try {
            this.subscriptions.put(key, state);
        }
        finally {
            this.writeLockUnlockSubscription(false);
        }
    }

    private String generateSubscriptionId(boolean xPath) {
        String subIdPrefix = null;
        subIdPrefix = !xPath ? "T" : "X";
        String key = subIdPrefix + "sub" + this.counter++ + "@" + WsmgCommonConstants.PREFIX;
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String checkSubscriptionExist(SubscriptionState state) {
        String key = null;
        this.readLockUnlockSubscriptions(true);
        try {
            for (String currentKey : this.subscriptions.keySet()) {
                SubscriptionState value = this.subscriptions.get(currentKey);
                if (!value.equals(state)) continue;
                value.setCreationTime(System.currentTimeMillis());
                log.info("Subscription Already exists. Using the current subscriptionId");
                key = currentKey;
                break;
            }
        }
        finally {
            this.readLockUnlockSubscriptions(false);
        }
        return key;
    }

    public void checkSubscriptionDB(WsmgStorage storage) throws AxisFault {
        List<SubscriptionEntry> subscriptionEntry = storage.getAllSubscription();
        if (subscriptionEntry == null) {
            return;
        }
        WSNotificationProcessingContextBuilder wsntBuilder = new WSNotificationProcessingContextBuilder();
        WSEProcessingContextBuilder wseBuilder = new WSEProcessingContextBuilder();
        for (int i = 0; i < subscriptionEntry.size(); ++i) {
            ProcessingContextBuilder processingCtxBuilder = null;
            log.info("Subscription No. " + i + " is " + subscriptionEntry.get(i).getSubscriptionId());
            StringReader sr = new StringReader(subscriptionEntry.get(i).getSubscribeXml());
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            try {
                XMLStreamReader inflow = inputFactory.createXMLStreamReader(sr);
                StAXOMBuilder builder = new StAXOMBuilder(inflow);
                OMElement subscribeXmlElement = builder.getDocumentElement();
                processingCtxBuilder = subscribeXmlElement.getNamespace().getNamespaceURI().equals(NameSpaceConstants.WSNT_NS.getNamespaceURI()) ? wsntBuilder : wseBuilder;
                String subscriptionId = subscriptionEntry.get(i).getSubscriptionId();
                ProcessingContext context = processingCtxBuilder.build(subscribeXmlElement);
                this.createSubscription(subscriptionId, context);
                continue;
            }
            catch (XMLStreamException e) {
                log.error("error occured while checking subscription db", (Throwable)e);
            }
        }
        RunTimeStatistics.totalSubscriptionsAtStartUp += (long)subscriptionEntry.size();
    }

    public void showAllSubscription() {
        String key2 = null;
        SubscriptionState value = null;
        Set<String> keySet = this.subscriptions.keySet();
        log.info("List of all subscriptions:");
        for (String key2 : keySet) {
            value = this.subscriptions.get(key2);
            log.info("******" + key2 + "-->" + value.getConsumerIPAddressStr() + "##" + value.getLocalTopic());
        }
    }

    public int unsubscribe(ProcessingContext ctx) throws AxisFault {
        String subscriptionId = ctx.getContextParameter(ContextParameters.SUB_ID);
        if (subscriptionId == null || subscriptionId.trim().length() == 0) {
            throw new AxisFault("subscription identifier is not provided");
        }
        this.removeSubscription(subscriptionId);
        ++RunTimeStatistics.totalUnSubscriptions;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int removeSubscription(String subId) throws AxisFault {
        SubscriptionState subscription = null;
        this.writeLockUnlockSubscription(true);
        try {
            subscription = this.subscriptions.remove(subId);
        }
        finally {
            this.writeLockUnlockSubscription(false);
        }
        if (subscription == null) {
            throw AxisFault.makeFault((Throwable)new RuntimeException("unknown subscription: " + subId));
        }
        this.subscriptionDB.delete(subId);
        for (AbstractMessageMatcher mm : this.wsmgConfig.getMessageMatchers()) {
            mm.handleUnsubscribe(subId);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSubscription(ProcessingContext ctx) throws AxisFault {
        String subscriptionId = ctx.getContextParameter(ContextParameters.SUB_ID);
        if (subscriptionId == null) {
            throw AxisFault.makeFault((Throwable)new RuntimeException("missing subscription id"));
        }
        this.writeLockUnlockSubscription(true);
        try {
            SubscriptionState subscription = this.subscriptions.get(subscriptionId);
            if (subscription == null) {
                throw AxisFault.makeFault((Throwable)new RuntimeException("no subscription found for id: " + subscriptionId));
            }
            subscription.resume();
        }
        finally {
            this.writeLockUnlockSubscription(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSubscription(ProcessingContext ctx) throws AxisFault {
        String subscriptionId = ctx.getContextParameter(ContextParameters.SUB_ID);
        if (subscriptionId == null) {
            throw AxisFault.makeFault((Throwable)new RuntimeException("missing subscription id"));
        }
        this.writeLockUnlockSubscription(true);
        try {
            SubscriptionState subscription = this.subscriptions.get(subscriptionId);
            if (subscription == null) {
                throw AxisFault.makeFault((Throwable)new RuntimeException("no subscription found for id: " + subscriptionId));
            }
            subscription.pause();
        }
        finally {
            this.writeLockUnlockSubscription(false);
        }
    }

    public void readLockUnlockSubscriptions(boolean lock) {
        ReentrantReadWriteLock.ReadLock readlock = this.subscriptionLock.readLock();
        this.lockUnlock(readlock, lock);
    }

    public void writeLockUnlockSubscription(boolean lock) {
        ReentrantReadWriteLock.WriteLock writeLock = this.subscriptionLock.writeLock();
        this.lockUnlock(writeLock, lock);
    }

    private void lockUnlock(Lock l, boolean lock) {
        if (lock) {
            l.lock();
        } else {
            l.unlock();
        }
    }
}

