/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker;

import java.util.List;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MessageContextBuilder;

public abstract class AbstractBrokerMsgReceiver
extends AbstractMessageReceiver {
    protected abstract MessageContext process(MessageContext var1, String var2) throws AxisFault;

    protected void invokeBusinessLogic(MessageContext inMsgContext) throws AxisFault {
        String operationName = this.getOperationName(inMsgContext);
        MessageContext outMsgContext = this.process(inMsgContext, operationName);
        if (outMsgContext != null) {
            outMsgContext.setTo(null);
            super.replicateState(inMsgContext);
            AxisEngine.send((MessageContext)outMsgContext);
        }
    }

    protected String getOperationName(MessageContext inMsg) throws AxisFault {
        AxisOperation op = inMsg.getOperationContext().getAxisOperation();
        if (op == null) {
            throw new AxisFault("Operation is not located, if this is doclit style the SOAP-ACTION should specified via the SOAP Action to use the RawXMLProvider");
        }
        String operationName = null;
        if (op.getName() == null || (operationName = JavaUtils.xmlNameToJava((String)op.getName().getLocalPart())) == null) {
            throw new AxisFault("invalid operation found");
        }
        return operationName;
    }

    protected MessageContext createOutputMessageContext(MessageContext inMsg, ProcessingContext processingContext) throws AxisFault {
        MessageContext outMsgContext = MessageContextBuilder.createOutMessageContext((MessageContext)inMsg);
        outMsgContext.getOperationContext().addMessageContext(outMsgContext);
        SOAPEnvelope outputEnvelope = this.getSOAPFactory(inMsg).getDefaultEnvelope();
        if (processingContext.getRespMessage() != null) {
            outputEnvelope.getBody().addChild((OMNode)processingContext.getRespMessage());
            if (processingContext.getResponseMsgNamespaces() != null) {
                this.declareResponseMsgNamespace(outputEnvelope, processingContext.getResponseMsgNamespaces());
            }
        }
        outMsgContext.setEnvelope(outputEnvelope);
        return outMsgContext;
    }

    private void declareResponseMsgNamespace(SOAPEnvelope outputEnvelope, List<OMNamespace> namespaces) {
        if (!namespaces.contains(NameSpaceConstants.WSA_NS)) {
            namespaces.add(NameSpaceConstants.WSA_NS);
        }
        for (OMNamespace ns : namespaces) {
            outputEnvelope.declareNamespace(ns);
        }
    }
}

