/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.subscription;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.airavata.wsmg.broker.ConsumerInfo;
import org.apache.airavata.wsmg.commons.util.OMElementComparator;
import org.apache.airavata.wsmg.messenger.OutGoingQueue;
import org.apache.airavata.wsmg.util.BrokerUtil;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.addressing.EndpointReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionState {
    private final Logger logger = LoggerFactory.getLogger(SubscriptionState.class);
    private long creationTime = 0L;
    private long lastAvailableTime = 0L;
    private int unAvailableCounter = 0;
    private boolean isNeverExpire = false;
    private boolean isWsrmPolicy;
    public String subId;
    public String curNotif;
    private String localTopicString;
    private String xpathString;
    private String subscribeXml;
    ConsumerInfo consumerInfo = null;
    EndpointReference consumerReference;
    URI consumerURI = null;
    private OutGoingQueue outGoingQueue;

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setId(String id) {
        this.subId = id;
    }

    public String getId() {
        return this.subId;
    }

    public boolean isWsrmPolicy() {
        return this.isWsrmPolicy;
    }

    public void setWsrmPolicy(boolean wsrmPolicy) {
        this.isWsrmPolicy = wsrmPolicy;
    }

    public SubscriptionState(EndpointReference consumerRef, boolean useNotify, boolean wsrmEnabled, String topic, String xpath, String type, OutGoingQueue outGoingQueue) {
        this.consumerReference = consumerRef;
        try {
            this.consumerURI = new URI(consumerRef.getAddress());
        }
        catch (URISyntaxException e) {
            this.logger.error("invalid consumer URI returned by axis om", (Throwable)e);
        }
        this.outGoingQueue = outGoingQueue;
        this.localTopicString = topic;
        this.xpathString = xpath;
        this.isWsrmPolicy = wsrmEnabled;
        this.consumerInfo = new ConsumerInfo(consumerRef.getAddress(), type, useNotify, false);
    }

    public void resume() {
        this.consumerInfo.setPaused(false);
    }

    public void pause() {
        this.consumerInfo.setPaused(true);
    }

    public String getConsumerIPAddressStr() {
        return this.consumerURI.toString();
    }

    public URI getConsumerAddressURI() {
        return this.consumerURI;
    }

    public String getLocalTopic() {
        return this.localTopicString;
    }

    public EndpointReference getConsumerReference() {
        return this.consumerReference;
    }

    public String getCurNotif() {
        return this.curNotif;
    }

    public void setCurNotif(String curNotif) {
        this.curNotif = curNotif;
    }

    public OutGoingQueue getOutGoingQueue() {
        return this.outGoingQueue;
    }

    public void setOutGoingQueue(OutGoingQueue outGoingQueue) {
        this.outGoingQueue = outGoingQueue;
    }

    public ConsumerInfo getConsumerInfo() {
        return this.consumerInfo;
    }

    public void resetUnAvailableCounter() {
        this.unAvailableCounter = 0;
    }

    public int addUnAvailableCounter() {
        ++this.unAvailableCounter;
        return this.unAvailableCounter;
    }

    public int getUnAvailableCounter() {
        return this.unAvailableCounter;
    }

    public String getXpathString() {
        return this.xpathString;
    }

    public void setXpathString(String xpathString) {
        this.xpathString = xpathString;
    }

    public boolean isNeverExpire() {
        return this.isNeverExpire;
    }

    public void setNeverExpire(boolean neverExpire) {
        this.isNeverExpire = neverExpire;
    }

    public long getLastAvailableTime() {
        return this.lastAvailableTime;
    }

    public void setLastAvailableTime(long lastAvailableTime) {
        this.lastAvailableTime = lastAvailableTime;
    }

    public void setSubscribeXml(String xml) {
        this.subscribeXml = xml;
    }

    public String getSubscribeXml() {
        return this.subscribeXml;
    }

    public boolean equals(Object o) {
        if (o instanceof SubscriptionState) {
            SubscriptionState subscription = (SubscriptionState)o;
            return BrokerUtil.sameStringValue(subscription.getLocalTopic(), this.getLocalTopic()) && BrokerUtil.sameStringValue(subscription.getXpathString(), this.getXpathString()) && BrokerUtil.sameStringValue(subscription.getConsumerIPAddressStr(), this.getConsumerIPAddressStr()) && this.equalReferenceParameters(subscription);
        }
        return false;
    }

    private boolean equalReferenceParameters(SubscriptionState anotherSubscription) {
        Map otherRefProperties = anotherSubscription.getConsumerReference().getAllReferenceParameters();
        Map myRefProperties = this.getConsumerReference().getAllReferenceParameters();
        if (otherRefProperties == null && myRefProperties == null) {
            return true;
        }
        if (otherRefProperties == null || myRefProperties == null) {
            return false;
        }
        if (otherRefProperties.size() != myRefProperties.size()) {
            return false;
        }
        for (Map.Entry entry : otherRefProperties.entrySet()) {
            OMElement otherElement;
            if (!myRefProperties.containsKey(entry.getKey())) {
                return false;
            }
            OMElement myElement = (OMElement)myRefProperties.get(entry.getKey());
            if (OMElementComparator.compare(myElement, otherElement = (OMElement)entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

