/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.broker.amqp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.airavata.common.utils.ApplicationSettings;
import org.apache.airavata.wsmg.broker.context.ProcessingContext;
import org.apache.airavata.wsmg.client.amqp.AMQPBroadcastSender;
import org.apache.airavata.wsmg.client.amqp.AMQPException;
import org.apache.airavata.wsmg.client.amqp.AMQPRoutingAwareClient;
import org.apache.airavata.wsmg.client.amqp.AMQPSender;
import org.apache.airavata.wsmg.client.amqp.AMQPTopicSender;
import org.apache.airavata.wsmg.client.amqp.AMQPUtil;
import org.apache.airavata.wsmg.commons.NameSpaceConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class AMQPNotificationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AMQPNotificationProcessor.class);
    private boolean amqpEnabled = false;
    private AMQPSender amqpSender = null;
    private AMQPTopicSender amqpTopicSender = null;
    private AMQPBroadcastSender amqpBroadcastSender = null;

    public void init() {
        String amqpEnabledAppSetting = ApplicationSettings.getSetting((String)"amqp.notification.enable", (String)"");
        if (!amqpEnabledAppSetting.isEmpty() && 1 == Integer.parseInt(amqpEnabledAppSetting)) {
            try {
                String host = ApplicationSettings.getSetting((String)"amqp.broker.host", (String)"localhost");
                String port = ApplicationSettings.getSetting((String)"amqp.broker.port", (String)"5672");
                String username = ApplicationSettings.getSetting((String)"amqp.broker.username", (String)"guest");
                String password = ApplicationSettings.getSetting((String)"amqp.broker.password", (String)"guest");
                Properties properties = new Properties();
                properties.setProperty("amqp.broker.host", host);
                properties.setProperty("amqp.broker.port", port);
                properties.setProperty("amqp.broker.username", username);
                properties.setProperty("amqp.broker.password", password);
                String className = ApplicationSettings.getSetting((String)"amqp.sender", (String)"");
                Class<?> clazz = Class.forName(className);
                this.amqpSender = (AMQPSender)clazz.getDeclaredConstructor(Properties.class).newInstance(properties);
                className = ApplicationSettings.getSetting((String)"amqp.topic.sender", (String)"");
                clazz = Class.forName(className);
                this.amqpTopicSender = (AMQPTopicSender)clazz.getDeclaredConstructor(Properties.class).newInstance(properties);
                className = ApplicationSettings.getSetting((String)"amqp.broadcast.sender", (String)"");
                clazz = Class.forName(className);
                this.amqpBroadcastSender = (AMQPBroadcastSender)clazz.getDeclaredConstructor(Properties.class).newInstance(properties);
                Element routingKeys = AMQPUtil.loadRoutingKeys();
                if (routingKeys != null) {
                    ((AMQPRoutingAwareClient)this.amqpSender).init(routingKeys);
                    ((AMQPRoutingAwareClient)this.amqpTopicSender).init(routingKeys);
                    ((AMQPRoutingAwareClient)this.amqpBroadcastSender).init(routingKeys);
                }
                this.amqpEnabled = true;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
        }
    }

    public void notify(ProcessingContext ctx, OMNamespace protocolNs) throws OMException {
        if (this.amqpEnabled) {
            ArrayList<OMElement> messages = new ArrayList<OMElement>();
            if (NameSpaceConstants.WSNT_NS.equals(protocolNs)) {
                OMElement messageElements = ctx.getSoapBody().getFirstElement();
                Iterator ite = messageElements.getChildrenWithLocalName("NotificationMessage");
                while (ite.hasNext()) {
                    try {
                        OMElement messageElement = (OMElement)ite.next();
                        OMElement message = messageElement.getFirstChildWithName(new QName(NameSpaceConstants.WSNT_NS.getNamespaceURI(), "Message")).getFirstElement();
                        messages.add(message);
                    }
                    catch (NullPointerException e) {
                        throw new OMException((Throwable)e);
                    }
                }
            } else {
                OMElement message = ctx.getSoapBody().getFirstElement();
                if (message != null) {
                    messages.add(message);
                }
            }
            try {
                for (OMElement message : messages) {
                    this.amqpBroadcastSender.Send(message);
                    this.amqpTopicSender.Send(message);
                    this.amqpSender.Send(message);
                }
            }
            catch (AMQPException e) {
                logger.warn("Failed to send AMQP notification.[Reason=" + e.getMessage() + "]");
            }
        }
    }
}

