/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.airavata.wsmg.util;

public enum WsNotificationOperations {

    NOTIFY("notify"), SUBSCRIBE("subscribe"), GET_CURRENT_MSG("getCurrentMessage"), PAUSE_REQUEST("gause"), RESUME_REQUEST(
            "resume"), PAUSE_SUBSCRIPTION("pauseSubscription"), RESUME_SUBSCRIPTION("resumeSubscription"), REGISTER_PUBLISHER(
            "registerPublisher"), UNSUBSCRIBE("unsubscribe");

    private final String name;

    private WsNotificationOperations(String n) {
        name = n;
    }

    public String toString() {
        return name;
    }

    public boolean equals(String s) {
        return name.equals(s);
    }

    public static WsNotificationOperations valueFrom(String s) {
        for (WsNotificationOperations status : WsNotificationOperations.values()) {
            if (status.toString().equalsIgnoreCase(s)) {
                return status;
            }

        }

        throw new RuntimeException("invalid Ws notification Operation:- " + s);

    }

}
