/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.wsmg.matching.XPath;

import edu.berkeley.cs.db.yfilter.filter.EXfilterBasic;
import edu.berkeley.cs.db.yfilter.filter.SystemGlobals;
import edu.berkeley.cs.db.yfilterplus.queryparser.Query;
import edu.berkeley.cs.db.yfilterplus.queryparser.XPQuery;
import edu.berkeley.cs.db.yfilterplus.xmltree.XMLTree;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.airavata.wsmg.broker.ConsumerInfo;
import org.apache.airavata.wsmg.broker.ConsumerList;
import org.apache.airavata.wsmg.broker.ConsumerListManager;
import org.apache.airavata.wsmg.broker.subscription.SubscriptionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YFilterInfo {
    private static final Logger logger = LoggerFactory.getLogger(YFilterInfo.class);
    private EXfilterBasic yfilter = new EXfilterBasic();
    private HashMap<Integer, String> yFilterIdToXPath = new HashMap();
    private HashMap<Integer, Query> yFilterIdToQuery = new HashMap();
    private HashMap<String, Integer> xPathToYFilterId = new HashMap();
    private ConsumerListManager consumerListmanager = new ConsumerListManager();
    private int index = 0;
    private int counter = 0;

    public EXfilterBasic getYfilter() {
        return this.yfilter;
    }

    public void setYfilter(EXfilterBasic yfilter) {
        this.yfilter = yfilter;
    }

    public HashMap<Integer, String> getYFilterIdToXPath() {
        return this.yFilterIdToXPath;
    }

    public void setYFilterIdToXPath(HashMap<Integer, String> filterIdToXPath) {
        this.yFilterIdToXPath = filterIdToXPath;
    }

    public void addXPathQuery(String xpathExpression, String subscriptionId, SubscriptionState subscribeRequest) throws RuntimeException {
        ++this.index;
        ++this.counter;
        Integer yFilterIdObj = this.xPathToYFilterId.get(xpathExpression);
        int yFilterId = -1;
        if (yFilterIdObj != null) {
            yFilterId = yFilterIdObj;
        } else {
            Query query = XPQuery.parseQuery((String)xpathExpression, (int)this.index);
            if (query == null) {
                throw new RuntimeException("Invalid XPath expression:" + xpathExpression);
            }
            yFilterId = this.yfilter.addQuery(query);
            this.xPathToYFilterId.put(xpathExpression, yFilterId);
            this.yFilterIdToXPath.put(new Integer(yFilterId), xpathExpression);
            this.yFilterIdToQuery.put(yFilterId, query);
        }
        this.consumerListmanager.addToConsumerList(xpathExpression, subscribeRequest, subscriptionId);
    }

    public int removeSubscription(String subscriptionId) {
        String xPath = this.consumerListmanager.getTokenBySubscriptionId(subscriptionId);
        int result = this.consumerListmanager.removeFromConsumerList(subscriptionId, xPath);
        if (result == 0) {
            return 0;
        }
        int currentConsumerCount = this.consumerListmanager.getConsumerListByToken(xPath).size();
        if (currentConsumerCount == 0) {
            Integer yFilterId = this.xPathToYFilterId.get(xPath);
            Query q = this.yFilterIdToQuery.get(yFilterId);
            this.yfilter.deleteQuery(q, q.getQueryId());
            this.yFilterIdToQuery.remove(yFilterId);
        }
        --this.counter;
        return result;
    }

    public List<ConsumerInfo> getMatchingConsumerList(String messageString) {
        LinkedList<ConsumerInfo> matchingConsumerList = new LinkedList<ConsumerInfo>();
        XMLTree tree = new XMLTree(new StringReader(messageString));
        this.yfilter.setEventSequence(tree.getEvents());
        this.yfilter.startParsing();
        if (!SystemGlobals.hasQueries) {
            System.out.println("no match");
            return matchingConsumerList;
        }
        for (Integer qid : this.yfilter.getMatchedQueries()) {
            String xpath = this.yFilterIdToXPath.get(qid);
            ConsumerList consumerList = this.consumerListmanager.getConsumerListByToken(xpath);
            if (consumerList == null) continue;
            matchingConsumerList.addAll(consumerList.getConsumerList());
        }
        this.yfilter.clear();
        return matchingConsumerList;
    }

    public int getCounter() {
        return this.counter;
    }
}

