/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.interpreter.service.handler;

import java.util.Map;
import java.util.UUID;
import org.apache.airavata.client.AiravataAPIFactory;
import org.apache.airavata.client.AiravataAPIUtils;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.exception.AiravataAPIInvocationException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.experiment.execution.ExperimentAdvanceOptions;
import org.apache.airavata.experiment.execution.InterpreterService;
import org.apache.airavata.interpreter.service.handler.MappingUtils;
import org.apache.airavata.workflow.model.wf.Workflow;
import org.apache.airavata.ws.monitor.EventData;
import org.apache.airavata.ws.monitor.EventDataListener;
import org.apache.airavata.ws.monitor.EventDataListenerAdapter;
import org.apache.airavata.ws.monitor.EventDataRepository;
import org.apache.airavata.ws.monitor.Monitor;
import org.apache.airavata.ws.monitor.MonitorConfiguration;
import org.apache.airavata.ws.monitor.MonitorUtil;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpretorSkeleton;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpreterServiceHandler
implements InterpreterService.Iface {
    private static final Logger log = LoggerFactory.getLogger(InterpreterServiceHandler.class);
    private WorkflowInterpretorSkeleton interpreterService;
    private AiravataAPI airavataAPI;

    public String runExperiment(String workflowTemplateName, Map<String, String> workflowInputs, ExperimentAdvanceOptions experimentAdOptions) throws TException {
        String user = this.getAiravataAPI().getUserManager().getAiravataUser();
        String gatewayId = this.getAiravataAPI().getGateway();
        try {
            Workflow workflowObj = this.extractWorkflow(workflowTemplateName);
            String experimentID = experimentAdOptions.getCustomExperimentId();
            workflowTemplateName = workflowObj.getName();
            if (experimentID == null || experimentID.isEmpty()) {
                experimentID = workflowTemplateName + "_" + UUID.randomUUID();
            }
            experimentAdOptions.setCustomExperimentId(experimentID);
            this.getAiravataAPI().getProvenanceManager().setWorkflowInstanceTemplateName(experimentID, workflowTemplateName);
            String submissionUser = this.getAiravataAPI().getUserManager().getAiravataUser();
            String executionUser = experimentAdOptions.getExecutionUser();
            if (executionUser == null) {
                executionUser = submissionUser;
            }
            experimentAdOptions.setExecutionUser(executionUser);
            this.runPreWorkflowExecutionTasks(experimentID, executionUser, experimentAdOptions.getMetadata(), experimentAdOptions.getExperimentName());
            EventDataListenerAdapter listener = new EventDataListenerAdapter(){

                public void notify(EventDataRepository eventDataRepo, EventData eventData) {
                }
            };
            this.getExperimentMonitor(experimentID, (EventDataListener)listener).startMonitoring();
            String workflowContent = this.extractWorkflowContent(workflowTemplateName);
            return this.getInterpreterService().setupAndLaunch(workflowContent, experimentID, gatewayId, user, workflowInputs, true, AiravataAPIUtils.createWorkflowContextHeaderBuilder((org.apache.airavata.client.api.ExperimentAdvanceOptions)MappingUtils.getExperimentOptionsObject(experimentAdOptions), (String)experimentAdOptions.getExecutionUser(), (String)user));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Monitor getExperimentMonitor(String experimentId, EventDataListener listener) throws AiravataAPIInvocationException {
        try {
            MonitorConfiguration monitorConfiguration = new MonitorConfiguration(this.getAiravataAPI().getAiravataManager().getMessageBoxServiceURL(), experimentId, true, this.getAiravataAPI().getAiravataManager().getMessageBoxServiceURL());
            final Monitor monitor = new Monitor(monitorConfiguration);
            monitor.printRawMessage(false);
            if (listener != null) {
                monitor.getEventDataRepository().registerEventListener(listener);
                listener.setExperimentMonitor(monitor);
            }
            if (!monitor.getExperimentId().equals(">")) {
                monitor.getEventDataRepository().registerEventListener((EventDataListener)new EventDataListenerAdapter(){

                    public void notify(EventDataRepository eventDataRepo, EventData eventData) {
                        if (eventData.getType() == MonitorUtil.EventType.WORKFLOW_TERMINATED || eventData.getType() == MonitorUtil.EventType.SENDING_FAULT) {
                            monitor.stopMonitoring();
                        }
                    }
                });
            }
            return monitor;
        }
        catch (Exception e) {
            throw new AiravataAPIInvocationException((Throwable)e);
        }
    }

    private void runPreWorkflowExecutionTasks(String experimentId, String user, String metadata, String experimentName) throws AiravataAPIInvocationException {
        if (user != null) {
            this.getAiravataAPI().getProvenanceManager().setExperimentUser(experimentId, user);
        }
        if (metadata != null) {
            this.getAiravataAPI().getProvenanceManager().setExperimentMetadata(experimentId, metadata);
        }
        if (experimentName == null) {
            experimentName = experimentId;
        }
        this.getAiravataAPI().getProvenanceManager().setExperimentName(experimentId, experimentName);
    }

    private Workflow extractWorkflow(String workflowName) throws AiravataAPIInvocationException {
        Workflow workflowObj = null;
        if (!workflowName.contains("http://airavata.apache.org/xbaya/xwf")) {
            workflowObj = this.getAiravataAPI().getWorkflowManager().getWorkflow(workflowName);
        } else {
            try {
                workflowObj = this.getAiravataAPI().getWorkflowManager().getWorkflowFromString(workflowName);
            }
            catch (AiravataAPIInvocationException e) {
                this.getAiravataAPI().getWorkflowManager().getWorkflow(workflowName);
            }
        }
        return workflowObj;
    }

    private AiravataAPI getAiravataAPI() {
        if (this.airavataAPI == null) {
            try {
                String systemUserName = ServerSettings.getSystemUser();
                String gateway = ServerSettings.getSystemUserGateway();
                this.airavataAPI = AiravataAPIFactory.getAPI((String)gateway, (String)systemUserName);
            }
            catch (ApplicationSettingsException e) {
                log.error("Unable to read the properties file", (Throwable)e);
            }
            catch (AiravataAPIInvocationException e) {
                log.error("Unable to create Airavata API", (Throwable)e);
            }
        }
        return this.airavataAPI;
    }

    private String extractWorkflowContent(String workflowName) throws AiravataAPIInvocationException {
        if (workflowName.contains("http://airavata.apache.org/xbaya/xwf")) {
            return workflowName;
        }
        return this.getAiravataAPI().getWorkflowManager().getWorkflowAsString(workflowName);
    }

    public void cancelExperiment(String experimentID) throws TException {
        try {
            this.getInterpreterService().haltWorkflow(experimentID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void suspendExperiment(String experimentID) throws TException {
        try {
            this.getInterpreterService().suspendWorkflow(experimentID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void resumeExperiment(String experimentID) throws TException {
        try {
            this.getInterpreterService().resumeWorkflow(experimentID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public WorkflowInterpretorSkeleton getInterpreterService() {
        if (this.interpreterService == null) {
            this.interpreterService = new WorkflowInterpretorSkeleton();
        }
        return this.interpreterService;
    }
}

