/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.local.provider.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.airavata.common.utils.MonitorPublisher;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.notification.events.GFacEvent;
import org.apache.airavata.gfac.core.notification.events.StartExecutionEvent;
import org.apache.airavata.gfac.core.provider.AbstractProvider;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.core.utils.OutputUtils;
import org.apache.airavata.gfac.local.utils.InputStreamToFileWriter;
import org.apache.airavata.gfac.local.utils.InputUtils;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.appdeployment.SetEnvPaths;
import org.apache.airavata.model.appcatalog.appinterface.InputDataObjectType;
import org.apache.airavata.model.messaging.event.JobIdentifier;
import org.apache.airavata.model.messaging.event.JobStatusChangeEvent;
import org.apache.airavata.model.messaging.event.TaskIdentifier;
import org.apache.airavata.model.messaging.event.TaskOutputChangeEvent;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.registry.cpi.RegistryModelType;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class LocalProvider
extends AbstractProvider {
    private static final Logger log = LoggerFactory.getLogger(LocalProvider.class);
    private ProcessBuilder builder;
    private List<String> cmdList = new ArrayList<String>();
    private String jobId;

    public void initialize(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        super.initialize(jobExecutionContext);
        this.buildCommand();
        this.initProcessBuilder(jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription());
        this.builder.environment().put("input", jobExecutionContext.getInputDir());
        this.builder.environment().put("output", jobExecutionContext.getOutputDir());
        this.builder.directory(new File(jobExecutionContext.getWorkingDir()));
        log.info("Command = " + InputUtils.buildCommand(this.cmdList));
        log.info("Working dir = " + this.builder.directory());
    }

    public void execute(JobExecutionContext jobExecutionContext) throws GFacProviderException {
        jobExecutionContext.getNotifier().publish((GFacEvent)new StartExecutionEvent());
        JobDetails jobDetails = new JobDetails();
        try {
            this.jobId = jobExecutionContext.getTaskData().getTaskID();
            jobDetails.setJobID(this.jobId);
            jobDetails.setJobDescription(jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getAppDeploymentDescription());
            jobExecutionContext.setJobDetails(jobDetails);
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.SETUP, (MonitorPublisher)this.monitorPublisher);
            Process process = this.builder.start();
            InputStreamToFileWriter standardOutWriter = new InputStreamToFileWriter(process.getInputStream(), jobExecutionContext.getStandardOutput());
            InputStreamToFileWriter standardErrorWriter = new InputStreamToFileWriter(process.getErrorStream(), jobExecutionContext.getStandardError());
            standardOutWriter.setDaemon(true);
            standardErrorWriter.setDaemon(true);
            standardOutWriter.start();
            standardErrorWriter.start();
            int returnValue = process.waitFor();
            standardOutWriter.join();
            standardErrorWriter.join();
            if (returnValue != 0) {
                log.error("Process finished with non zero return value. Process may have failed");
            } else {
                log.info("Process finished with return value of zero.");
            }
            StringBuffer buf = new StringBuffer();
            buf.append("Executed ").append(InputUtils.buildCommand(this.cmdList)).append(" on the localHost, working directory = ").append(jobExecutionContext.getWorkingDir()).append(" tempDirectory = ").append(jobExecutionContext.getScratchLocation()).append(" With the status ").append(String.valueOf(returnValue));
            log.info(buf.toString());
            JobIdentifier jobIdentity = new JobIdentifier(jobExecutionContext.getJobDetails().getJobID(), jobExecutionContext.getTaskData().getTaskID(), jobExecutionContext.getWorkflowNodeDetails().getNodeInstanceId(), jobExecutionContext.getExperimentID(), jobExecutionContext.getGatewayID());
            this.getMonitorPublisher().publish((Object)new JobStatusChangeEvent(JobState.COMPLETE, jobIdentity));
        }
        catch (IOException io) {
            throw new GFacProviderException(io.getMessage(), (Throwable)io);
        }
        catch (InterruptedException e) {
            throw new GFacProviderException(e.getMessage(), (Throwable)e);
        }
        catch (GFacException e) {
            throw new GFacProviderException(e.getMessage(), (Throwable)e);
        }
    }

    public void dispose(JobExecutionContext jobExecutionContext) throws GFacProviderException {
        try {
            ArrayList outputArray = new ArrayList();
            String stdOutStr = GFacUtils.readFileToString((String)jobExecutionContext.getStandardOutput());
            String stdErrStr = GFacUtils.readFileToString((String)jobExecutionContext.getStandardError());
            Map output = jobExecutionContext.getOutMessageContext().getParameters();
            OutputUtils.fillOutputFromStdout((Map)output, (String)stdOutStr, (String)stdErrStr, outputArray);
            TaskDetails taskDetails = (TaskDetails)this.registry.get(RegistryModelType.TASK_DETAIL, (Object)jobExecutionContext.getTaskData().getTaskID());
            if (taskDetails != null) {
                taskDetails.setApplicationOutputs(outputArray);
                this.registry.update(RegistryModelType.TASK_DETAIL, (Object)taskDetails, (Object)taskDetails.getTaskID());
            }
            this.registry.add(ChildDataType.EXPERIMENT_OUTPUT, outputArray, (Object)jobExecutionContext.getExperimentID());
            TaskIdentifier taskIdentity = new TaskIdentifier(jobExecutionContext.getTaskData().getTaskID(), jobExecutionContext.getWorkflowNodeDetails().getNodeInstanceId(), jobExecutionContext.getExperimentID(), jobExecutionContext.getGatewayID());
            this.getMonitorPublisher().publish((Object)new TaskOutputChangeEvent(outputArray, taskIdentity));
        }
        catch (XmlException e) {
            throw new GFacProviderException("Cannot read output:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException io) {
            throw new GFacProviderException(io.getMessage(), (Throwable)io);
        }
        catch (Exception e) {
            throw new GFacProviderException("Error in retrieving results", (Throwable)e);
        }
    }

    public boolean cancelJob(JobExecutionContext jobExecutionContext) throws GFacException {
        throw new NotImplementedException();
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
    }

    public void monitor(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
    }

    private void buildCommand() {
        this.cmdList.add(this.jobExecutionContext.getExecutablePath());
        Map inputParameters = this.jobExecutionContext.getInMessageContext().getParameters();
        Comparator<InputDataObjectType> inputOrderComparator = new Comparator<InputDataObjectType>(){

            @Override
            public int compare(InputDataObjectType inputDataObjectType, InputDataObjectType t1) {
                return inputDataObjectType.getInputOrder() - t1.getInputOrder();
            }
        };
        TreeSet<InputDataObjectType> sortedInputSet = new TreeSet<InputDataObjectType>(inputOrderComparator);
        for (Object object : inputParameters.values()) {
            if (!(object instanceof InputDataObjectType)) continue;
            InputDataObjectType inputDOT = (InputDataObjectType)object;
            sortedInputSet.add(inputDOT);
        }
        for (InputDataObjectType inputDataObjectType : sortedInputSet) {
            if (inputDataObjectType.getApplicationArgument() != null && !inputDataObjectType.getApplicationArgument().equals("")) {
                this.cmdList.add(inputDataObjectType.getApplicationArgument());
            }
            if (inputDataObjectType.getValue() == null || inputDataObjectType.getValue().equals("")) continue;
            this.cmdList.add(inputDataObjectType.getValue());
        }
    }

    private void initProcessBuilder(ApplicationDeploymentDescription app) {
        this.builder = new ProcessBuilder(this.cmdList);
        List setEnvironment = app.getSetEnvironment();
        if (setEnvironment != null) {
            for (SetEnvPaths envPath : setEnvironment) {
                Map<String, String> builderEnv = this.builder.environment();
                builderEnv.put(envPath.getName(), envPath.getValue());
            }
        }
    }

    public void initProperties(Map<String, String> properties) throws GFacProviderException, GFacException {
    }

    public static class LocalProviderJobData {
        private String applicationName;
        private List<String> inputParameters;
        private String workingDir;
        private String inputDir;
        private String outputDir;

        public String getApplicationName() {
            return this.applicationName;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public List<String> getInputParameters() {
            return this.inputParameters;
        }

        public void setInputParameters(List<String> inputParameters) {
            this.inputParameters = inputParameters;
        }

        public String getWorkingDir() {
            return this.workingDir;
        }

        public void setWorkingDir(String workingDir) {
            this.workingDir = workingDir;
        }

        public String getInputDir() {
            return this.inputDir;
        }

        public void setInputDir(String inputDir) {
            this.inputDir = inputDir;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public void setOutputDir(String outputDir) {
            this.outputDir = outputDir;
        }
    }
}

