/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.local.handler;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.AbstractHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.model.appcatalog.appinterface.DataType;
import org.apache.airavata.model.appcatalog.appinterface.InputDataObjectType;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalInputHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(LocalInputHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        Map inputParameters = jobExecutionContext.getInMessageContext().getParameters();
        for (Map.Entry inputParamEntry : inputParameters.entrySet()) {
            InputDataObjectType inputDataObject;
            if (!(inputParamEntry.getValue() instanceof InputDataObjectType) || (inputDataObject = (InputDataObjectType)inputParamEntry.getValue()).getType() != DataType.URI || inputDataObject == null || inputDataObject.getValue().equals("")) continue;
            try {
                inputDataObject.setValue(this.stageFile(jobExecutionContext.getInputDir(), inputDataObject.getValue()));
            }
            catch (IOException e) {
                throw new GFacHandlerException("Error while data staging sourceFile= " + inputDataObject.getValue());
            }
        }
    }

    private String stageFile(String inputDir, String sourceFilePath) throws IOException {
        int i = sourceFilePath.lastIndexOf(File.separator);
        String substring = sourceFilePath.substring(i + 1);
        if (inputDir.endsWith("/")) {
            inputDir = inputDir.substring(0, inputDir.length() - 1);
        }
        String targetFilePath = inputDir + File.separator + substring;
        if (sourceFilePath.startsWith("file")) {
            sourceFilePath = sourceFilePath.substring(sourceFilePath.indexOf(":") + 1, sourceFilePath.length());
        }
        File sourceFile = new File(sourceFilePath);
        File targetFile = new File(targetFilePath);
        if (targetFile.exists()) {
            targetFile.delete();
        }
        logger.info("staging source file : " + sourceFilePath + " to target file : " + targetFilePath);
        FileUtils.copyFile((File)sourceFile, (File)targetFile);
        return targetFilePath;
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }
}

