/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.local.handler;

import java.io.File;
import java.util.Properties;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.GFacHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDirectorySetupHandler
implements GFacHandler {
    private static final Logger log = LoggerFactory.getLogger(LocalDirectorySetupHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        log.info("Invoking LocalDirectorySetupHandler ...");
        log.debug("working directory = " + jobExecutionContext.getWorkingDir());
        log.debug("temp directory = " + jobExecutionContext.getWorkingDir());
        this.makeFileSystemDir(jobExecutionContext.getWorkingDir());
        this.makeFileSystemDir(jobExecutionContext.getInputDir());
        this.makeFileSystemDir(jobExecutionContext.getOutputDir());
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
    }

    private void makeFileSystemDir(String dir) throws GFacHandlerException {
        File f = new File(dir);
        if (f.isDirectory() && f.exists()) {
            return;
        }
        if (!new File(dir).mkdir()) {
            throw new GFacHandlerException("Cannot create directory " + dir);
        }
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }
}

