/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.local.utils;

import java.io.File;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProviderUtil {
    private static final Logger log = LoggerFactory.getLogger(LocalProviderUtil.class);

    private void makeFileSystemDir(String dir) throws GFacProviderException {
        File f = new File(dir);
        if (f.isDirectory() && f.exists()) {
            return;
        }
        if (!new File(dir).mkdir()) {
            throw new GFacProviderException("Cannot make directory " + dir);
        }
    }

    public void makeDirectory(JobExecutionContext jobExecutionContext) throws GFacProviderException {
        log.info("working diectroy = " + jobExecutionContext.getWorkingDir());
        log.info("temp directory = " + jobExecutionContext.getScratchLocation());
        this.makeFileSystemDir(jobExecutionContext.getWorkingDir());
        this.makeFileSystemDir(jobExecutionContext.getScratchLocation());
        this.makeFileSystemDir(jobExecutionContext.getInputDir());
        this.makeFileSystemDir(jobExecutionContext.getOutputDir());
    }
}

