/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.local.provider.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.monitor.MonitorID;
import org.apache.airavata.gfac.core.monitor.state.JobStatusChangeRequest;
import org.apache.airavata.gfac.core.notification.events.GFacEvent;
import org.apache.airavata.gfac.core.notification.events.StartExecutionEvent;
import org.apache.airavata.gfac.core.provider.AbstractProvider;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.provider.utils.ProviderUtils;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.core.utils.OutputUtils;
import org.apache.airavata.gfac.local.utils.InputStreamToFileWriter;
import org.apache.airavata.gfac.local.utils.InputUtils;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.NameValuePairType;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class LocalProvider
extends AbstractProvider {
    private static final Logger log = LoggerFactory.getLogger(LocalProvider.class);
    private ProcessBuilder builder;
    private List<String> cmdList = new ArrayList<String>();
    private String jobId;

    public void initialize(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        super.initialize(jobExecutionContext);
        ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        this.buildCommand(app.getExecutableLocation(), ProviderUtils.getInputParameters((JobExecutionContext)jobExecutionContext));
        this.initProcessBuilder(app);
        this.builder.environment().put("input", app.getInputDataDirectory());
        this.builder.environment().put("output", app.getOutputDataDirectory());
        this.builder.directory(new File(app.getStaticWorkingDirectory()));
        log.info("Command = " + InputUtils.buildCommand(this.cmdList));
        log.info("Working dir = " + this.builder.directory());
        for (String key : this.builder.environment().keySet()) {
            log.info("Env[" + key + "] = " + this.builder.environment().get(key));
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws GFacProviderException {
        jobExecutionContext.getNotifier().publish((GFacEvent)new StartExecutionEvent());
        ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        JobDetails jobDetails = new JobDetails();
        try {
            this.jobId = jobExecutionContext.getTaskData().getTaskID();
            jobDetails.setJobID(this.jobId);
            jobDetails.setJobDescription(app.toString());
            jobExecutionContext.setJobDetails(jobDetails);
            jobDetails.setJobDescription(app.toString());
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.SETUP);
            Process process = this.builder.start();
            InputStreamToFileWriter standardOutWriter = new InputStreamToFileWriter(process.getInputStream(), app.getStandardOutput());
            InputStreamToFileWriter standardErrorWriter = new InputStreamToFileWriter(process.getErrorStream(), app.getStandardError());
            standardOutWriter.setDaemon(true);
            standardErrorWriter.setDaemon(true);
            standardOutWriter.start();
            standardErrorWriter.start();
            int returnValue = process.waitFor();
            standardOutWriter.join();
            standardErrorWriter.join();
            if (returnValue != 0) {
                log.error("Process finished with non zero return value. Process may have failed");
            } else {
                log.info("Process finished with return value of zero.");
            }
            StringBuffer buf = new StringBuffer();
            buf.append("Executed ").append(InputUtils.buildCommand(this.cmdList)).append(" on the localHost, working directory = ").append(app.getStaticWorkingDirectory()).append(" tempDirectory = ").append(app.getScratchWorkingDirectory()).append(" With the status ").append(String.valueOf(returnValue));
            log.info(buf.toString());
            MonitorID monitorID = new MonitorID(jobExecutionContext.getApplicationContext().getHostDescription(), this.jobId, jobExecutionContext.getTaskData().getTaskID(), jobExecutionContext.getWorkflowNodeDetails().getNodeInstanceId(), jobExecutionContext.getExperimentID(), jobExecutionContext.getExperiment().getUserName());
            JobStatusChangeRequest jobStatusChangeRequest = new JobStatusChangeRequest(monitorID);
            jobStatusChangeRequest.setState(JobState.COMPLETE);
            this.getMonitorPublisher().publish((Object)jobStatusChangeRequest);
        }
        catch (IOException io) {
            throw new GFacProviderException(io.getMessage(), (Throwable)io);
        }
        catch (InterruptedException e) {
            throw new GFacProviderException(e.getMessage(), (Throwable)e);
        }
        catch (GFacException e) {
            throw new GFacProviderException(e.getMessage(), (Throwable)e);
        }
    }

    public void dispose(JobExecutionContext jobExecutionContext) throws GFacProviderException {
        ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        try {
            ArrayList outputArray = new ArrayList();
            String stdOutStr = GFacUtils.readFileToString((String)app.getStandardOutput());
            String stdErrStr = GFacUtils.readFileToString((String)app.getStandardError());
            Map output = jobExecutionContext.getOutMessageContext().getParameters();
            OutputUtils.fillOutputFromStdout((Map)output, (String)stdOutStr, (String)stdErrStr, outputArray);
            this.registry.add(ChildDataType.EXPERIMENT_OUTPUT, outputArray, (Object)jobExecutionContext.getExperimentID());
        }
        catch (XmlException e) {
            throw new GFacProviderException("Cannot read output:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException io) {
            throw new GFacProviderException(io.getMessage(), (Throwable)io);
        }
        catch (Exception e) {
            throw new GFacProviderException("Error in retrieving results", (Throwable)e);
        }
    }

    public void cancelJob(String jobId, JobExecutionContext jobExecutionContext) throws GFacException {
        throw new NotImplementedException();
    }

    private void buildCommand(String executable, List<String> inputParameterList) {
        this.cmdList.add(executable);
        this.cmdList.addAll(inputParameterList);
    }

    private void initProcessBuilder(ApplicationDeploymentDescriptionType app) {
        this.builder = new ProcessBuilder(this.cmdList);
        NameValuePairType[] env = app.getApplicationEnvironmentArray();
        if (env != null && env.length > 0) {
            Map<String, String> builderEnv = this.builder.environment();
            for (NameValuePairType entry : env) {
                builderEnv.put(entry.getName(), entry.getValue());
            }
        }
    }

    public void initProperties(Map<String, String> properties) throws GFacProviderException, GFacException {
    }

    public static class LocalProviderJobData {
        private String applicationName;
        private List<String> inputParameters;
        private String workingDir;
        private String inputDir;
        private String outputDir;

        public String getApplicationName() {
            return this.applicationName;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public List<String> getInputParameters() {
            return this.inputParameters;
        }

        public void setInputParameters(List<String> inputParameters) {
            this.inputParameters = inputParameters;
        }

        public String getWorkingDir() {
            return this.workingDir;
        }

        public void setWorkingDir(String workingDir) {
            this.workingDir = workingDir;
        }

        public String getInputDir() {
            return this.inputDir;
        }

        public void setInputDir(String inputDir) {
            this.inputDir = inputDir;
        }

        public String getOutputDir() {
            return this.outputDir;
        }

        public void setOutputDir(String outputDir) {
            this.outputDir = outputDir;
        }
    }
}

