/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.local.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamToFileWriter
extends Thread {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private BufferedReader in;
    private BufferedWriter out;

    public InputStreamToFileWriter(InputStream in, String out) throws IOException {
        this.in = new BufferedReader(new InputStreamReader(in));
        this.out = new BufferedWriter(new FileWriter(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String line = null;
            while ((line = this.in.readLine()) != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(line);
                }
                this.out.write(line);
                this.out.newLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.in != null) {
                try {
                    this.in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

