/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.local.handler;

import java.io.File;
import java.util.Properties;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.GFacHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.HostDescriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDirectorySetupHandler
implements GFacHandler {
    private static final Logger log = LoggerFactory.getLogger(LocalDirectorySetupHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        log.info("Invoking GramDirectorySetupHandler ...");
        HostDescriptionType type = jobExecutionContext.getApplicationContext().getHostDescription().getType();
        ApplicationDescription applicationDeploymentDescription = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription();
        ApplicationDeploymentDescriptionType app = applicationDeploymentDescription.getType();
        log.debug("working diectroy = " + app.getStaticWorkingDirectory());
        log.debug("temp directory = " + app.getScratchWorkingDirectory());
        this.makeFileSystemDir(app.getStaticWorkingDirectory(), jobExecutionContext);
        this.makeFileSystemDir(app.getScratchWorkingDirectory(), jobExecutionContext);
        this.makeFileSystemDir(app.getInputDataDirectory(), jobExecutionContext);
        this.makeFileSystemDir(app.getOutputDataDirectory(), jobExecutionContext);
    }

    private void makeFileSystemDir(String dir, JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        File f = new File(dir);
        if (f.isDirectory() && f.exists()) {
            return;
        }
        if (!new File(dir).mkdir()) {
            throw new GFacHandlerException("Cannot make directory " + dir);
        }
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }
}

