/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.airavata.appcatalog.cpi.AppCatalog;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.RequestData;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.context.MessageContext;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.security.TokenizedMyProxyAuthInfo;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.gsi.ssh.api.ServerInfo;
import org.apache.airavata.gsi.ssh.api.authentication.AuthenticationInfo;
import org.apache.airavata.gsi.ssh.api.job.JobDescriptor;
import org.apache.airavata.gsi.ssh.api.job.JobManagerConfiguration;
import org.apache.airavata.gsi.ssh.impl.GSISSHAbstractCluster;
import org.apache.airavata.gsi.ssh.impl.PBSCluster;
import org.apache.airavata.gsi.ssh.util.CommonUtils;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationParallelismType;
import org.apache.airavata.model.appcatalog.appinterface.DataType;
import org.apache.airavata.model.appcatalog.appinterface.InputDataObjectType;
import org.apache.airavata.model.appcatalog.appinterface.OutputDataObjectType;
import org.apache.airavata.model.appcatalog.computeresource.JobManagerCommand;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManager;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.computeresource.SecurityProtocol;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.workspace.experiment.ComputationalResourceScheduling;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFACGSISSHUtils {
    private static final Logger logger = LoggerFactory.getLogger(GFACGSISSHUtils.class);
    public static final String PBS_JOB_MANAGER = "pbs";
    public static final String SLURM_JOB_MANAGER = "slurm";
    public static final String SUN_GRID_ENGINE_JOB_MANAGER = "UGE";
    public static final String LSF_JOB_MANAGER = "lsf";
    public static int maxClusterCount = 5;
    public static Map<String, List<Cluster>> clusters = new HashMap<String, List<Cluster>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSecurityContext(JobExecutionContext jobExecutionContext) throws GFacException, ApplicationSettingsException {
        block28: {
            JobSubmissionInterface jobSubmissionInterface = jobExecutionContext.getPreferredJobSubmissionInterface();
            JobSubmissionProtocol jobProtocol = jobSubmissionInterface.getJobSubmissionProtocol();
            try {
                AppCatalog appCatalog = jobExecutionContext.getAppCatalog();
                SSHJobSubmission sshJobSubmission = appCatalog.getComputeResource().getSSHJobSubmission(jobSubmissionInterface.getJobSubmissionInterfaceId());
                if (jobProtocol == JobSubmissionProtocol.GLOBUS || jobProtocol == JobSubmissionProtocol.UNICORE || jobProtocol == JobSubmissionProtocol.CLOUD || jobProtocol == JobSubmissionProtocol.LOCAL) {
                    logger.error("This is a wrong method to invoke to non ssh host types,please check your gfac-config.xml");
                    break block28;
                }
                if (jobProtocol != JobSubmissionProtocol.SSH || sshJobSubmission.getSecurityProtocol() != SecurityProtocol.GSI) break block28;
                String credentialStoreToken = jobExecutionContext.getCredentialStoreToken();
                RequestData requestData = new RequestData(jobExecutionContext.getGatewayID());
                requestData.setTokenId(credentialStoreToken);
                PBSCluster pbsCluster = null;
                GSISecurityContext context = null;
                TokenizedMyProxyAuthInfo tokenizedMyProxyAuthInfo = new TokenizedMyProxyAuthInfo(requestData);
                CredentialReader credentialReader = GFacUtils.getCredentialReader();
                if (credentialReader != null) {
                    CertificateCredential credential = null;
                    try {
                        credential = (CertificateCredential)credentialReader.getCredential(jobExecutionContext.getGatewayID(), credentialStoreToken);
                        requestData.setMyProxyUserName(credential.getCommunityUser().getUserName());
                    }
                    catch (Exception e) {
                        logger.error(e.getLocalizedMessage());
                    }
                }
                String key = requestData.getMyProxyUserName() + jobExecutionContext.getHostName() + sshJobSubmission.getSshPort();
                boolean recreate = false;
                Map<String, List<Cluster>> map = clusters;
                synchronized (map) {
                    if (clusters.containsKey(key) && clusters.get(key).size() < maxClusterCount) {
                        recreate = true;
                    } else if (clusters.containsKey(key)) {
                        int i = new Random().nextInt(Integer.MAX_VALUE) % maxClusterCount;
                        if (clusters.get(key).get(i).getSession().isConnected()) {
                            pbsCluster = (PBSCluster)clusters.get(key).get(i);
                        } else {
                            clusters.get(key).remove(i);
                            recreate = true;
                        }
                        if (!recreate) {
                            try {
                                pbsCluster.listDirectory("~/");
                            }
                            catch (Exception e) {
                                clusters.get(key).remove(i);
                                logger.info("Connection found the connection map is expired, so we create from the scratch");
                                ++maxClusterCount;
                                recreate = true;
                            }
                            logger.info("Re-using the same connection used with the connection string:" + key);
                            context = new GSISecurityContext(tokenizedMyProxyAuthInfo.getCredentialReader(), requestData, (Cluster)pbsCluster);
                        }
                    } else {
                        recreate = true;
                    }
                    if (recreate) {
                        ServerInfo serverInfo = new ServerInfo(requestData.getMyProxyUserName(), jobExecutionContext.getHostName(), sshJobSubmission.getSshPort());
                        JobManagerConfiguration jConfig = null;
                        String installedParentPath = sshJobSubmission.getResourceJobManager().getJobManagerBinPath();
                        String jobManager = sshJobSubmission.getResourceJobManager().getResourceJobManagerType().toString();
                        if (jobManager == null) {
                            logger.error("No Job Manager is configured, so we are picking pbs as the default job manager");
                            jConfig = CommonUtils.getPBSJobManager((String)installedParentPath);
                        } else if (PBS_JOB_MANAGER.equalsIgnoreCase(jobManager)) {
                            jConfig = CommonUtils.getPBSJobManager((String)installedParentPath);
                        } else if (SLURM_JOB_MANAGER.equalsIgnoreCase(jobManager)) {
                            jConfig = CommonUtils.getSLURMJobManager((String)installedParentPath);
                        } else if (SUN_GRID_ENGINE_JOB_MANAGER.equalsIgnoreCase(jobManager)) {
                            jConfig = CommonUtils.getUGEJobManager((String)installedParentPath);
                        } else if (LSF_JOB_MANAGER.equalsIgnoreCase(jobManager)) {
                            jConfig = CommonUtils.getLSFJobManager((String)installedParentPath);
                        }
                        pbsCluster = new PBSCluster(serverInfo, (AuthenticationInfo)tokenizedMyProxyAuthInfo, jConfig);
                        context = new GSISecurityContext(tokenizedMyProxyAuthInfo.getCredentialReader(), requestData, (Cluster)pbsCluster);
                        List<Object> pbsClusters = null;
                        pbsClusters = !clusters.containsKey(key) ? new ArrayList() : clusters.get(key);
                        pbsClusters.add(pbsCluster);
                        clusters.put(key, pbsClusters);
                    }
                }
                jobExecutionContext.addSecurityContext(jobExecutionContext.getHostName(), context);
            }
            catch (Exception e) {
                throw new GFacException("An error occurred while creating GSI security context", (Throwable)e);
            }
        }
    }

    public static JobDescriptor createJobDescriptor(JobExecutionContext jobExecutionContext, Cluster cluster) {
        Map jobManagerCommands;
        ApplicationParallelismType parallelism;
        List postJobCommands;
        List preJobCommands;
        ComputeResourcePreference computeResourcePreference;
        JobDescriptor jobDescriptor = new JobDescriptor();
        TaskDetails taskData = jobExecutionContext.getTaskData();
        ResourceJobManager resourceJobManager = jobExecutionContext.getResourceJobManager();
        try {
            if (ServerSettings.getSetting((String)"job.notification.enable").equalsIgnoreCase("true")) {
                jobDescriptor.setMailOptions(ServerSettings.getSetting((String)"job.notification.flags"));
                String emailids = ServerSettings.getSetting((String)"job.notification.emailids");
                if (jobExecutionContext.getTaskData().isSetEmailAddresses()) {
                    List emailList = jobExecutionContext.getTaskData().getEmailAddresses();
                    String elist = GFacUtils.listToCsv((List)emailList, (char)',');
                    emailids = emailids != null && !emailids.isEmpty() ? emailids + "," + elist : elist;
                }
                if (emailids != null && !emailids.isEmpty()) {
                    logger.info("Email list: " + emailids);
                    jobDescriptor.setMailAddress(emailids);
                }
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error("ApplicationSettingsException : " + e.getLocalizedMessage());
        }
        jobDescriptor.setCallBackIp(ServerSettings.getIp());
        jobDescriptor.setCallBackPort(ServerSettings.getSetting((String)"gfac.server.port", (String)"8950"));
        jobDescriptor.setInputDirectory(jobExecutionContext.getInputDir());
        jobDescriptor.setOutputDirectory(jobExecutionContext.getOutputDir());
        jobDescriptor.setExecutablePath(jobExecutionContext.getExecutablePath());
        jobDescriptor.setStandardOutFile(jobExecutionContext.getStandardOutput());
        jobDescriptor.setStandardErrorFile(jobExecutionContext.getStandardError());
        String computationalProjectAccount = taskData.getTaskScheduling().getComputationalProjectAccount();
        taskData.getEmailAddresses();
        if (computationalProjectAccount == null && (computeResourcePreference = jobExecutionContext.getApplicationContext().getComputeResourcePreference()) != null) {
            computationalProjectAccount = computeResourcePreference.getAllocationProjectNumber();
        }
        if (computationalProjectAccount != null) {
            jobDescriptor.setAcountString(computationalProjectAccount);
        }
        Random random = new Random();
        int i = random.nextInt(Integer.MAX_VALUE);
        jobDescriptor.setJobName("A" + String.valueOf(i + 99999999));
        jobDescriptor.setWorkingDirectory(jobExecutionContext.getWorkingDir());
        ArrayList<String> inputValues = new ArrayList<String>();
        MessageContext input = jobExecutionContext.getInMessageContext();
        Comparator<InputDataObjectType> inputOrderComparator = new Comparator<InputDataObjectType>(){

            @Override
            public int compare(InputDataObjectType inputDataObjectType, InputDataObjectType t1) {
                return inputDataObjectType.getInputOrder() - t1.getInputOrder();
            }
        };
        TreeSet<InputDataObjectType> sortedInputSet = new TreeSet<InputDataObjectType>(inputOrderComparator);
        for (Object v : input.getParameters().values()) {
            if (!(v instanceof InputDataObjectType)) continue;
            InputDataObjectType inputDOT = (InputDataObjectType)v;
            sortedInputSet.add(inputDOT);
        }
        for (InputDataObjectType inputDataObjectType : sortedInputSet) {
            if (!inputDataObjectType.isRequiredToAddedToCommandLine()) continue;
            if (inputDataObjectType.getApplicationArgument() != null && !inputDataObjectType.getApplicationArgument().equals("")) {
                inputValues.add(inputDataObjectType.getApplicationArgument());
            }
            if (inputDataObjectType.getValue() == null || inputDataObjectType.getValue().equals("")) continue;
            if (inputDataObjectType.getType() == DataType.URI) {
                String filePath = inputDataObjectType.getValue();
                filePath = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1, filePath.length());
                inputValues.add(filePath);
                continue;
            }
            inputValues.add(inputDataObjectType.getValue());
        }
        Map outputParams = jobExecutionContext.getOutMessageContext().getParameters();
        for (Object outputParam : outputParams.values()) {
            if (!(outputParam instanceof OutputDataObjectType)) continue;
            OutputDataObjectType output = (OutputDataObjectType)outputParam;
            if (output.getApplicationArgument() != null && !output.getApplicationArgument().equals("")) {
                inputValues.add(output.getApplicationArgument());
            }
            if (output.getValue() == null || output.getValue().equals("") || !output.isRequiredToAddedToCommandLine() || output.getType() != DataType.URI) continue;
            String filePath = output.getValue();
            filePath = filePath.substring(filePath.lastIndexOf(File.separatorChar) + 1, filePath.length());
            inputValues.add(filePath);
        }
        jobDescriptor.setInputValues(inputValues);
        jobDescriptor.setUserName(((GSISSHAbstractCluster)cluster).getServerInfo().getUserName());
        jobDescriptor.setShellName("/bin/bash");
        jobDescriptor.setAllEnvExport(true);
        jobDescriptor.setOwner(((PBSCluster)cluster).getServerInfo().getUserName());
        ComputationalResourceScheduling computationalResourceScheduling = taskData.getTaskScheduling();
        if (computationalResourceScheduling != null) {
            int totalNodeCount = computationalResourceScheduling.getNodeCount();
            int totalCPUCount = computationalResourceScheduling.getTotalCPUCount();
            if (computationalResourceScheduling.getComputationalProjectAccount() != null) {
                jobDescriptor.setAcountString(computationalResourceScheduling.getComputationalProjectAccount());
            }
            if (computationalResourceScheduling.getQueueName() != null) {
                jobDescriptor.setQueueName(computationalResourceScheduling.getQueueName());
            }
            if (totalNodeCount > 0) {
                jobDescriptor.setNodes(totalNodeCount);
            }
            if (computationalResourceScheduling.getComputationalProjectAccount() != null) {
                jobDescriptor.setAcountString(computationalResourceScheduling.getComputationalProjectAccount());
            }
            if (computationalResourceScheduling.getQueueName() != null) {
                jobDescriptor.setQueueName(computationalResourceScheduling.getQueueName());
            }
            if (totalCPUCount > 0) {
                int ppn = totalCPUCount / totalNodeCount;
                jobDescriptor.setProcessesPerNode(ppn);
                jobDescriptor.setCPUCount(totalCPUCount);
            }
            if (computationalResourceScheduling.getWallTimeLimit() > 0) {
                jobDescriptor.setMaxWallTime(String.valueOf(computationalResourceScheduling.getWallTimeLimit()));
                if (resourceJobManager.getResourceJobManagerType().equals((Object)ResourceJobManagerType.LSF)) {
                    jobDescriptor.setMaxWallTimeForLSF(String.valueOf(computationalResourceScheduling.getWallTimeLimit()));
                }
            }
            if (computationalResourceScheduling.getTotalPhysicalMemory() > 0) {
                jobDescriptor.setUsedMemory(computationalResourceScheduling.getTotalPhysicalMemory() + "");
            }
        } else {
            logger.error("Task scheduling cannot be null at this point..");
        }
        ApplicationDeploymentDescription appDepDescription = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription();
        List moduleCmds = appDepDescription.getModuleLoadCmds();
        if (moduleCmds != null) {
            for (Object moduleCmd : moduleCmds) {
                jobDescriptor.addModuleLoadCommands((String)moduleCmd);
            }
        }
        if ((preJobCommands = appDepDescription.getPreJobCommands()) != null) {
            for (Object preJobCommand : preJobCommands) {
                jobDescriptor.addPreJobCommand(GFACGSISSHUtils.parseCommand((String)preJobCommand, jobExecutionContext));
            }
        }
        if ((postJobCommands = appDepDescription.getPostJobCommands()) != null) {
            for (String postJobCommand : postJobCommands) {
                jobDescriptor.addPostJobCommand(GFACGSISSHUtils.parseCommand(postJobCommand, jobExecutionContext));
            }
        }
        if (!((parallelism = appDepDescription.getParallelism()) == null || parallelism != ApplicationParallelismType.MPI && parallelism != ApplicationParallelismType.OPENMP && parallelism != ApplicationParallelismType.OPENMP_MPI || (jobManagerCommands = resourceJobManager.getJobManagerCommands()) == null || jobManagerCommands.isEmpty())) {
            for (JobManagerCommand command : jobManagerCommands.keySet()) {
                if (command != JobManagerCommand.SUBMISSION) continue;
                String commandVal = (String)jobManagerCommands.get(command);
                jobDescriptor.setJobSubmitter(commandVal);
            }
        }
        return jobDescriptor;
    }

    private static String parseCommand(String value, JobExecutionContext jobExecutionContext) {
        String parsedValue = value.replaceAll("\\$workingDir", jobExecutionContext.getWorkingDir());
        parsedValue = parsedValue.replaceAll("\\$inputDir", jobExecutionContext.getInputDir());
        parsedValue = parsedValue.replaceAll("\\$outputDir", jobExecutionContext.getOutputDir());
        return parsedValue;
    }
}

