/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.provider.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.airavata.appcatalog.cpi.AppCatalogException;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.MonitorPublisher;
import org.apache.airavata.gfac.ExecutionMode;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.cpi.BetterGfacImpl;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.handler.ThreadedHandler;
import org.apache.airavata.gfac.core.notification.events.GFacEvent;
import org.apache.airavata.gfac.core.notification.events.StartExecutionEvent;
import org.apache.airavata.gfac.core.provider.AbstractProvider;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gfac.monitor.email.EmailBasedMonitor;
import org.apache.airavata.gfac.monitor.email.EmailMonitorFactory;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.gsi.ssh.api.SSHApiException;
import org.apache.airavata.gsi.ssh.api.job.JobDescriptor;
import org.apache.airavata.model.appcatalog.appdeployment.ApplicationDeploymentDescription;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.MonitorMode;
import org.apache.airavata.model.appcatalog.computeresource.ResourceJobManagerType;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHProvider
extends AbstractProvider {
    private static final Logger log = LoggerFactory.getLogger(GSISSHProvider.class);

    public void initProperties(Map<String, String> properties) throws GFacProviderException, GFacException {
    }

    public void initialize(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        super.initialize(jobExecutionContext);
        try {
            String hostAddress = jobExecutionContext.getHostName();
            if (jobExecutionContext.getSecurityContext(hostAddress) == null) {
                GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
            }
        }
        catch (ApplicationSettingsException e) {
            log.error(e.getMessage());
            throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
        }
        catch (GFacException e) {
            throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        log.info("Invoking GSISSH Provider Invoke ...");
        StringBuffer data = new StringBuffer();
        jobExecutionContext.getNotifier().publish((GFacEvent)new StartExecutionEvent());
        ComputeResourceDescription computeResourceDescription = jobExecutionContext.getApplicationContext().getComputeResourceDescription();
        ApplicationDeploymentDescription appDeployDesc = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription();
        JobDetails jobDetails = new JobDetails();
        Cluster cluster = null;
        try {
            if (jobExecutionContext.getSecurityContext(jobExecutionContext.getHostName()) != null) {
                cluster = ((GSISecurityContext)jobExecutionContext.getSecurityContext(jobExecutionContext.getHostName())).getPbsCluster();
            }
            if (cluster == null) {
                throw new GFacProviderException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
            JobDescriptor jobDescriptor = GFACGSISSHUtils.createJobDescriptor(jobExecutionContext, cluster);
            jobDetails.setJobName(jobDescriptor.getJobName());
            log.info(jobDescriptor.toXML());
            data.append("jobDesc=").append(jobDescriptor.toXML());
            jobDetails.setJobDescription(jobDescriptor.toXML());
            String jobID = cluster.submitBatchJob(jobDescriptor);
            jobExecutionContext.setJobDetails(jobDetails);
            if (jobID == null) {
                jobDetails.setJobID("none");
                GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.FAILED, (MonitorPublisher)this.monitorPublisher);
            } else {
                jobDetails.setJobID(jobID.split("\\.")[0]);
                GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.SUBMITTED, (MonitorPublisher)this.monitorPublisher);
            }
            data.append(",jobId=").append(jobDetails.getJobID());
            this.monitor(jobExecutionContext);
        }
        catch (Exception e) {
            String error = "Error submitting the job to host " + computeResourceDescription.getHostName() + " message: " + e.getMessage();
            log.error(error);
            jobDetails.setJobID("none");
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.FAILED, (MonitorPublisher)this.monitorPublisher);
            StringWriter errors = new StringWriter();
            e.printStackTrace(new PrintWriter(errors));
            GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)errors.toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            throw new GFacProviderException(error, (Throwable)e);
        }
        finally {
            log.info("Saving data for future recovery: ");
            log.info(data.toString());
            GFacUtils.saveHandlerData((JobExecutionContext)jobExecutionContext, (StringBuffer)data, (String)((Object)((Object)this)).getClass().getName());
        }
    }

    public void removeFromMonitorHandlers(JobExecutionContext jobExecutionContext, SSHJobSubmission sshJobSubmission, String jobID) throws GFacHandlerException {
        List daemonHandlers = BetterGfacImpl.getDaemonHandlers();
        if (daemonHandlers == null) {
            daemonHandlers = BetterGfacImpl.getDaemonHandlers();
        }
        ThreadedHandler pullMonitorHandler = null;
        ThreadedHandler pushMonitorHandler = null;
        MonitorMode monitorMode = sshJobSubmission.getMonitorMode();
        for (ThreadedHandler threadedHandler : daemonHandlers) {
            if ("org.apache.airavata.gfac.monitor.handlers.GridPullMonitorHandler".equals(threadedHandler.getClass().getName())) {
                pullMonitorHandler = threadedHandler;
                if (monitorMode == null || monitorMode == MonitorMode.POLL_JOB_MANAGER) {
                    jobExecutionContext.setProperty("cancel", (Object)"true");
                    pullMonitorHandler.invoke(jobExecutionContext);
                    continue;
                }
                log.error("Currently we only support Pull and Push monitoring and monitorMode should be PULL to handle by the GridPullMonitorHandler");
                continue;
            }
            if (!"org.apache.airavata.gfac.monitor.handlers.GridPushMonitorHandler".equals(threadedHandler.getClass().getName())) continue;
            pushMonitorHandler = threadedHandler;
            if (monitorMode == null || monitorMode == MonitorMode.XSEDE_AMQP_SUBSCRIBE) {
                pushMonitorHandler.invoke(jobExecutionContext);
                continue;
            }
            log.error("Currently we only support Pull and Push monitoring and monitorMode should be PUSH to handle by the GridPushMonitorHandler");
        }
        if (pullMonitorHandler == null && pushMonitorHandler == null && ExecutionMode.ASYNCHRONOUS.equals((Object)jobExecutionContext.getGFacConfiguration().getExecutionMode())) {
            log.error("No Daemon handler is configured in gfac-config.xml, either pull or push, so monitoring will not invoked, execution is configured as asynchronous, so Outhandler will not be invoked");
        }
    }

    public void dispose(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
    }

    public boolean cancelJob(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        log.info("canceling the job status in GSISSHProvider!!!!!");
        JobDetails jobDetails = jobExecutionContext.getJobDetails();
        String hostName = jobExecutionContext.getHostName();
        try {
            Cluster cluster = null;
            if (jobExecutionContext.getSecurityContext(hostName) == null) {
                GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
            }
            if ((cluster = ((GSISecurityContext)jobExecutionContext.getSecurityContext(hostName)).getPbsCluster()) == null) {
                throw new GFacProviderException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
            if (jobDetails == null) {
                log.error("There is not JobDetails so cancelations cannot perform !!!");
                return false;
            }
            if (jobDetails.getJobID() == null) {
                log.error("No Job Id is set, so cannot perform the cancel operation !!!");
                return false;
            }
            cluster.cancelJob(jobDetails.getJobID());
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.CANCELED, (MonitorPublisher)this.monitorPublisher);
            return true;
        }
        catch (SSHApiException e) {
            String error = "Error submitting the job to host " + jobExecutionContext.getHostName() + " message: " + e.getMessage();
            log.error(error);
            jobDetails.setJobID("none");
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.FAILED, (MonitorPublisher)this.monitorPublisher);
            GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            throw new GFacProviderException(error, (Throwable)e);
        }
        catch (Exception e) {
            String error = "Error submitting the job to host " + jobExecutionContext.getHostName() + " message: " + e.getMessage();
            log.error(error);
            jobDetails.setJobID("none");
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.FAILED, (MonitorPublisher)this.monitorPublisher);
            GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            throw new GFacProviderException(error, (Throwable)e);
        }
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        String jobDesc;
        String jobId;
        String hostName;
        block12: {
            log.info("Invoking Recovering for the Experiment: " + jobExecutionContext.getExperimentID());
            ComputeResourceDescription computeResourceDescription = jobExecutionContext.getApplicationContext().getComputeResourceDescription();
            hostName = jobExecutionContext.getHostName();
            jobId = "";
            jobDesc = "";
            try {
                String pluginData = GFacUtils.getHandlerData((JobExecutionContext)jobExecutionContext, (String)((Object)((Object)this)).getClass().getName());
                String[] split = pluginData.split(",");
                if (split.length < 2) {
                    try {
                        this.execute(jobExecutionContext);
                    }
                    catch (GFacException e) {
                        log.error("Error while  recovering provider", (Throwable)e);
                        throw new GFacProviderException("Error recovering provider", (Throwable)e);
                    }
                    return;
                }
                jobDesc = split[0].substring(7);
                jobId = split[1].substring(6);
                log.info("Following data have recovered: ");
                log.info("Job Description: " + jobDesc);
                log.info("Job Id: " + jobId);
                if (jobId != null && !"none".equals(jobId) && !"".equals(jobId)) break block12;
                try {
                    this.execute(jobExecutionContext);
                }
                catch (GFacException e) {
                    log.error("Error while  recovering provider", (Throwable)e);
                    throw new GFacProviderException("Error recovering provider", (Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                log.error("Error while  recovering provider", (Throwable)e);
            }
        }
        try {
            JobDetails jobDetails = new JobDetails();
            jobDetails.setJobDescription(jobDesc);
            jobDetails.setJobID(jobId);
            jobExecutionContext.setJobDetails(jobDetails);
            if (jobExecutionContext.getSecurityContext(hostName) == null) {
                try {
                    GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
                }
                catch (ApplicationSettingsException e) {
                    log.error(e.getMessage());
                    throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
                }
            }
            this.monitor(jobExecutionContext);
        }
        catch (Exception e) {
            log.error("Error while recover the job", (Throwable)e);
            throw new GFacProviderException("Error delegating already ran job to Monitoring", (Throwable)e);
        }
    }

    public void monitor(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        String jobSubmissionInterfaceId = jobExecutionContext.getPreferredJobSubmissionInterface().getJobSubmissionInterfaceId();
        SSHJobSubmission sshJobSubmission = null;
        try {
            sshJobSubmission = jobExecutionContext.getAppCatalog().getComputeResource().getSSHJobSubmission(jobSubmissionInterfaceId);
        }
        catch (AppCatalogException e) {
            throw new GFacException("Error while reading compute resource", (Throwable)e);
        }
        if (jobExecutionContext.getPreferredJobSubmissionProtocol() == JobSubmissionProtocol.SSH) {
            MonitorMode monitorMode = sshJobSubmission.getMonitorMode();
            if (monitorMode != null && monitorMode == MonitorMode.JOB_EMAIL_NOTIFICATION_MONITOR) {
                try {
                    EmailBasedMonitor emailBasedMonitor = EmailMonitorFactory.getEmailBasedMonitor((ResourceJobManagerType)sshJobSubmission.getResourceJobManager().getResourceJobManagerType());
                    emailBasedMonitor.addToJobMonitorMap(jobExecutionContext);
                }
                catch (AiravataException e) {
                    throw new GFacHandlerException("Error while activating email job monitoring ", (Throwable)e);
                }
                return;
            }
        } else {
            throw new GFacException(MessageFormat.format("expId: {0} , jobId {1} :- Job monitor mode {2} is not yet implemented, please change compute resource monitor mode to {3}", jobExecutionContext.getExperimentID(), jobExecutionContext.getJobDetails().getJobID(), sshJobSubmission.getMonitorMode().name(), MonitorMode.JOB_EMAIL_NOTIFICATION_MONITOR.name()));
        }
    }
}

