/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.handler;

import java.util.List;
import java.util.Properties;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.AbstractHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gfac.ssh.util.HandleOutputs;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewGSISSHOutputHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(NewGSISSHOutputHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        String hostAddress = jobExecutionContext.getHostName();
        try {
            if (jobExecutionContext.getSecurityContext(hostAddress) == null) {
                GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
            }
        }
        catch (Exception e) {
            try {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            }
            catch (GFacException e1) {
                log.error(e1.getLocalizedMessage());
            }
            log.error(e.getMessage());
            throw new GFacHandlerException("Error while creating SSHSecurityContext", e, new String[]{e.getLocalizedMessage()});
        }
        Cluster cluster = null;
        try {
            cluster = ((GSISecurityContext)jobExecutionContext.getSecurityContext(hostAddress)).getPbsCluster();
            if (cluster == null) {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)"Security context is not set properly", (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
                throw new GFacProviderException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            try {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            }
            catch (GFacException e1) {
                log.error(e1.getLocalizedMessage());
            }
            throw new GFacHandlerException("Error while creating SSHSecurityContext", e, new String[]{e.getLocalizedMessage()});
        }
        super.invoke(jobExecutionContext);
        List outputArray = HandleOutputs.handleOutputs((JobExecutionContext)jobExecutionContext, (Cluster)cluster);
        try {
            this.registry.add(ChildDataType.EXPERIMENT_OUTPUT, (Object)outputArray, (Object)jobExecutionContext.getExperimentID());
        }
        catch (RegistryException e) {
            throw new GFacHandlerException((Exception)((Object)e));
        }
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }
}

