/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.handler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.AbstractHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.core.utils.OutputUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.model.appcatalog.appinterface.DataType;
import org.apache.airavata.model.appcatalog.appinterface.OutputDataObjectType;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHOutputHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(GSISSHOutputHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        int index = 0;
        int oldIndex = 0;
        List<Object> oldFiles = new ArrayList();
        StringBuffer data = new StringBuffer("|");
        String hostAddress = jobExecutionContext.getHostName();
        try {
            if (jobExecutionContext.getSecurityContext(hostAddress) == null) {
                GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
            }
        }
        catch (Exception e) {
            try {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            }
            catch (GFacException e1) {
                log.error(e1.getLocalizedMessage());
            }
            log.error(e.getMessage());
            throw new GFacHandlerException("Error while creating SSHSecurityContext", e, new String[]{e.getLocalizedMessage()});
        }
        DataTransferDetails detail = new DataTransferDetails();
        TransferStatus status = new TransferStatus();
        Cluster cluster = null;
        try {
            File localStdErrFile;
            File localStdOutFile;
            cluster = ((GSISecurityContext)jobExecutionContext.getSecurityContext(hostAddress)).getPbsCluster();
            if (cluster == null) {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)"Security context is not set properly", (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
                throw new GFacProviderException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
            String pluginData = GFacUtils.getHandlerData((JobExecutionContext)jobExecutionContext, (String)((Object)((Object)this)).getClass().getName());
            if (pluginData != null) {
                try {
                    oldIndex = Integer.parseInt(pluginData.split("\\|")[0].trim());
                    oldFiles = Arrays.asList(pluginData.split("\\|")[1].split(","));
                    if (oldIndex == oldFiles.size()) {
                        log.info("Old data looks good !!!!");
                    } else {
                        oldIndex = 0;
                        oldFiles.clear();
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Previously stored data " + pluginData + " is wrong so we continue the operations");
                }
            }
            String timeStampedExperimentID = GFacUtils.createUniqueNameWithDate((String)jobExecutionContext.getExperimentID());
            TaskDetails taskData = jobExecutionContext.getTaskData();
            String outputDataDir = null;
            if (outputDataDir == null) {
                outputDataDir = File.separator + "tmp";
            }
            outputDataDir = outputDataDir + File.separator + jobExecutionContext.getExperimentID() + "-" + jobExecutionContext.getTaskData().getTaskID();
            new File(outputDataDir).mkdirs();
            String stdOutStr = "";
            if (index < oldIndex) {
                localStdOutFile = new File((String)oldFiles.get(index));
                data.append((String)oldFiles.get(index++)).append(",");
            } else {
                int i = 0;
                localStdOutFile = new File(outputDataDir + File.separator + jobExecutionContext.getApplicationName() + ".stdout");
                while (stdOutStr.isEmpty()) {
                    try {
                        cluster.scpFrom(jobExecutionContext.getStandardOutput(), localStdOutFile.getAbsolutePath());
                        stdOutStr = GFacUtils.readFileToString((String)localStdOutFile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        log.error(e.getLocalizedMessage());
                        Thread.sleep(2000L);
                    }
                    if (++i != 3) continue;
                }
                StringBuffer temp = new StringBuffer(data.append(localStdOutFile.getAbsolutePath()).append(",").toString());
                GFacUtils.saveHandlerData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
            }
            if (index < oldIndex) {
                localStdErrFile = new File((String)oldFiles.get(index));
                data.append((String)oldFiles.get(index++)).append(",");
            } else {
                localStdErrFile = new File(outputDataDir + File.separator + jobExecutionContext.getApplicationName() + ".stderr");
                cluster.scpFrom(jobExecutionContext.getStandardError(), localStdErrFile.getAbsolutePath());
                StringBuffer temp = new StringBuffer(data.append(localStdErrFile.getAbsolutePath()).append(",").toString());
                GFacUtils.saveHandlerData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
            }
            String stdErrStr = GFacUtils.readFileToString((String)localStdErrFile.getAbsolutePath());
            status.setTransferState(TransferState.STDOUT_DOWNLOAD);
            detail.setTransferStatus(status);
            detail.setTransferDescription("STDOUT:" + localStdOutFile.getAbsolutePath());
            this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
            status.setTransferState(TransferState.STDERROR_DOWNLOAD);
            detail.setTransferStatus(status);
            detail.setTransferDescription("STDERR:" + localStdErrFile.getAbsolutePath());
            this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
            ArrayList<OutputDataObjectType> outputArray = new ArrayList<OutputDataObjectType>();
            Map output = jobExecutionContext.getOutMessageContext().getParameters();
            Set keys = output.keySet();
            for (String paramName : keys) {
                OutputDataObjectType outputDataObjectType = (OutputDataObjectType)output.get(paramName);
                if (DataType.URI == outputDataObjectType.getType()) {
                    String outputFile;
                    List outputList = null;
                    int retry = 3;
                    while (retry > 0) {
                        outputList = cluster.listDirectory(jobExecutionContext.getOutputDir());
                        if (outputList.size() == 1 && ((String)outputList.get(0)).isEmpty()) {
                            Thread.sleep(10000L);
                        } else {
                            if (outputList.size() > 0) break;
                            Thread.sleep(10000L);
                        }
                        if (--retry == 0) {
                            // empty if block
                        }
                        Thread.sleep(10000L);
                    }
                    if (outputList.size() == 0 || ((String)outputList.get(0)).isEmpty() || outputList.size() > 1) {
                        OutputUtils.fillOutputFromStdout((Map)output, (String)stdOutStr, (String)stdErrStr, outputArray);
                        Set strings = output.keySet();
                        outputArray.clear();
                        for (String key : strings) {
                            OutputDataObjectType dataObjectType;
                            StringBuffer temp;
                            String fileName;
                            String localFile;
                            OutputDataObjectType outputDataObjectType1 = (OutputDataObjectType)output.get(key);
                            if (DataType.URI == outputDataObjectType1.getType()) {
                                String localFile2;
                                String downloadFile = outputDataObjectType1.getValue();
                                if (index < oldIndex) {
                                    localFile2 = (String)oldFiles.get(index);
                                    data.append((String)oldFiles.get(index++)).append(",");
                                } else {
                                    cluster.scpFrom(downloadFile, outputDataDir);
                                    String fileName2 = downloadFile.substring(downloadFile.lastIndexOf(File.separatorChar) + 1, downloadFile.length());
                                    localFile2 = outputDataDir + File.separator + fileName2;
                                    StringBuffer temp2 = new StringBuffer(data.append(localFile2).append(",").toString());
                                    GFacUtils.saveHandlerData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp2.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                                }
                                jobExecutionContext.addOutputFile(localFile2);
                                outputDataObjectType1.setValue(localFile2);
                                OutputDataObjectType dataObjectType2 = new OutputDataObjectType();
                                dataObjectType2.setValue(localFile2);
                                dataObjectType2.setName(key);
                                dataObjectType2.setType(DataType.URI);
                                outputArray.add(dataObjectType2);
                                continue;
                            }
                            if (DataType.STDOUT == outputDataObjectType1.getType()) {
                                if (index < oldIndex) {
                                    localFile = (String)oldFiles.get(index);
                                    data.append((String)oldFiles.get(index++)).append(",");
                                } else {
                                    fileName = localStdOutFile.getName();
                                    localFile = outputDataDir + File.separator + fileName;
                                    temp = new StringBuffer(data.append(localFile).append(",").toString());
                                    GFacUtils.saveHandlerData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                                }
                                jobExecutionContext.addOutputFile(localFile);
                                outputDataObjectType1.setValue(localFile);
                                dataObjectType = new OutputDataObjectType();
                                dataObjectType.setValue(localFile);
                                dataObjectType.setName(key);
                                dataObjectType.setType(DataType.STDOUT);
                                outputArray.add(dataObjectType);
                                continue;
                            }
                            if (DataType.STDERR != outputDataObjectType1.getType()) continue;
                            if (index < oldIndex) {
                                localFile = (String)oldFiles.get(index);
                                data.append((String)oldFiles.get(index++)).append(",");
                            } else {
                                fileName = localStdErrFile.getName();
                                localFile = outputDataDir + File.separator + fileName;
                                temp = new StringBuffer(data.append(localFile).append(",").toString());
                                GFacUtils.saveHandlerData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                            }
                            jobExecutionContext.addOutputFile(localFile);
                            outputDataObjectType1.setValue(localFile);
                            dataObjectType = new OutputDataObjectType();
                            dataObjectType.setValue(localFile);
                            dataObjectType.setName(key);
                            dataObjectType.setType(DataType.STDERR);
                            outputArray.add(dataObjectType);
                        }
                        break;
                    }
                    if (outputList.size() != 1) continue;
                    String valueList = (String)outputList.get(0);
                    if (index < oldIndex) {
                        outputFile = (String)oldFiles.get(index);
                        data.append((String)oldFiles.get(index++)).append(",");
                    } else {
                        cluster.scpFrom(jobExecutionContext.getOutputDir() + File.separator + valueList, outputDataDir);
                        outputFile = outputDataDir + File.separator + valueList;
                        jobExecutionContext.addOutputFile(outputFile);
                        StringBuffer temp = new StringBuffer(data.append(outputFile).append(",").toString());
                        GFacUtils.saveHandlerData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                    }
                    jobExecutionContext.addOutputFile(outputFile);
                    outputDataObjectType.setValue(outputFile);
                    OutputDataObjectType dataObjectType = new OutputDataObjectType();
                    dataObjectType.setValue(valueList);
                    dataObjectType.setName(paramName);
                    dataObjectType.setType(DataType.URI);
                    outputArray.add(dataObjectType);
                    continue;
                }
                OutputUtils.fillOutputFromStdout((Map)output, (String)stdOutStr, (String)stdErrStr, outputArray);
            }
            if ((outputArray == null || outputArray.isEmpty()) && jobExecutionContext.getTaskData().getAdvancedOutputDataHandling() == null) {
                throw new GFacHandlerException("Empty Output returned from the Application, Double check the applicationand ApplicationDescriptor output Parameter Names");
            }
            jobExecutionContext.setStandardError(localStdErrFile.getAbsolutePath());
            jobExecutionContext.setStandardOutput(localStdOutFile.getAbsolutePath());
            jobExecutionContext.setOutputDir(outputDataDir);
            status.setTransferState(TransferState.DOWNLOAD);
            detail.setTransferStatus(status);
            detail.setTransferDescription(outputDataDir);
            this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
            this.registry.add(ChildDataType.EXPERIMENT_OUTPUT, outputArray, (Object)jobExecutionContext.getExperimentID());
            this.fireTaskOutputChangeEvent(jobExecutionContext, outputArray);
        }
        catch (Exception e) {
            try {
                status.setTransferState(TransferState.FAILED);
                detail.setTransferStatus(status);
                detail.setTransferDescription(e.getLocalizedMessage());
                this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
            }
            catch (Exception e1) {
                throw new GFacHandlerException("Error persisting status", e1, new String[]{e1.getLocalizedMessage()});
            }
            throw new GFacHandlerException("Error in retrieving results", (Throwable)e);
        }
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        this.invoke(jobExecutionContext);
    }
}

