/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.context.MessageContext;
import org.apache.airavata.gfac.core.handler.AbstractHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.model.appcatalog.appinterface.DataType;
import org.apache.airavata.model.appcatalog.appinterface.InputDataObjectType;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHInputHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(GSISSHInputHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        int index = 0;
        int oldIndex = 0;
        List<Object> oldFiles = new ArrayList();
        MessageContext inputNew = new MessageContext();
        DataTransferDetails detail = new DataTransferDetails();
        TransferStatus status = new TransferStatus();
        StringBuffer data = new StringBuffer("|");
        Cluster cluster = null;
        try {
            String hostAddress = jobExecutionContext.getHostName();
            if (jobExecutionContext.getSecurityContext(hostAddress) == null) {
                GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
            }
            if ((cluster = ((GSISecurityContext)jobExecutionContext.getSecurityContext(hostAddress)).getPbsCluster()) == null) {
                throw new GFacException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
            String pluginData = GFacUtils.getHandlerData((JobExecutionContext)jobExecutionContext, (String)((Object)((Object)this)).getClass().getName());
            if (pluginData != null) {
                try {
                    oldIndex = Integer.parseInt(pluginData.split("\\|")[0].trim());
                    oldFiles = Arrays.asList(pluginData.split("\\|")[1].split(","));
                    if (oldIndex == oldFiles.size()) {
                        log.info("Old data looks good !!!!");
                    } else {
                        oldIndex = 0;
                        oldFiles.clear();
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Previously stored data " + pluginData + " is wrong so we continue the operations");
                }
            }
            if (jobExecutionContext.getSecurityContext(hostAddress) == null) {
                try {
                    GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
                }
                catch (ApplicationSettingsException e) {
                    log.error(e.getMessage());
                    try {
                        GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                    }
                    catch (GFacException e1) {
                        log.error(e1.getLocalizedMessage());
                    }
                    throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
                }
            }
            log.info("Invoking SCPInputHandler");
            MessageContext input = jobExecutionContext.getInMessageContext();
            Set parameters = input.getParameters().keySet();
            for (String paramName : parameters) {
                InputDataObjectType inputParamType = (InputDataObjectType)input.getParameters().get(paramName);
                String paramValue = inputParamType.getValue();
                if (inputParamType.getType() == DataType.URI) {
                    if (index < oldIndex) {
                        log.info("Input File: " + paramValue + " is already transfered, so we skip this operation !!!");
                        inputParamType.setValue((String)oldFiles.get(index));
                        data.append((String)oldFiles.get(index++)).append(",");
                    } else {
                        String stageInputFile = GSISSHInputHandler.stageInputFiles(cluster, jobExecutionContext, paramValue);
                        inputParamType.setValue(stageInputFile);
                        StringBuffer temp = new StringBuffer(data.append(stageInputFile).append(",").toString());
                        status.setTransferState(TransferState.UPLOAD);
                        detail.setTransferStatus(status);
                        detail.setTransferDescription("Input Data Staged: " + stageInputFile);
                        this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                        GFacUtils.saveHandlerData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                    }
                }
                inputNew.getParameters().put(paramName, inputParamType);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            status.setTransferState(TransferState.FAILED);
            detail.setTransferDescription(e.getLocalizedMessage());
            detail.setTransferStatus(status);
            try {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
                this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
            }
            catch (Exception e1) {
                throw new GFacHandlerException("Error persisting status", e1, new String[]{e1.getLocalizedMessage()});
            }
            throw new GFacHandlerException("Error while input File Staging", e, new String[]{e.getLocalizedMessage()});
        }
        jobExecutionContext.setInMessageContext(inputNew);
    }

    private static String stageInputFiles(Cluster cluster, JobExecutionContext jobExecutionContext, String paramValue) throws IOException, GFacException {
        int i = paramValue.lastIndexOf(File.separator);
        String substring = paramValue.substring(i + 1);
        try {
            String targetFile = jobExecutionContext.getInputDir() + File.separator + substring;
            if (paramValue.startsWith("file")) {
                paramValue = paramValue.substring(paramValue.indexOf(":") + 1, paramValue.length());
            }
            boolean success = false;
            int j = 1;
            while (!success) {
                block6: {
                    try {
                        cluster.scpTo(targetFile, paramValue);
                        success = true;
                    }
                    catch (Exception e) {
                        log.info(e.getLocalizedMessage());
                        Thread.sleep(2000L);
                        if (j != 3) break block6;
                        throw new GFacHandlerException("Error while input File Staging", e, new String[]{e.getLocalizedMessage()});
                    }
                }
                ++j;
            }
            return targetFile;
        }
        catch (Exception e) {
            throw new GFacHandlerException("Error while input File Staging", e, new String[]{e.getLocalizedMessage()});
        }
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        this.invoke(jobExecutionContext);
    }
}

