/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.AbstractHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHDirectorySetupHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(GSISSHDirectorySetupHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        try {
            String hostAddress = jobExecutionContext.getHostName();
            if (jobExecutionContext.getSecurityContext(hostAddress) == null) {
                GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
            }
        }
        catch (Exception e) {
            try {
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)errors.toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            }
            catch (GFacException e1) {
                log.error(e1.getLocalizedMessage());
            }
            throw new GFacHandlerException("Error while creating SSHSecurityContext", e, new String[]{e.getLocalizedMessage()});
        }
        log.info("Setup SSH job directorties");
        super.invoke(jobExecutionContext);
        this.makeDirectory(jobExecutionContext);
    }

    private void makeDirectory(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        Cluster cluster = null;
        try {
            String hostAddress = jobExecutionContext.getHostName();
            cluster = ((GSISecurityContext)jobExecutionContext.getSecurityContext(hostAddress)).getPbsCluster();
            if (cluster == null) {
                try {
                    GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)"Security context is not set properly", (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                }
                catch (GFacException e1) {
                    log.error(e1.getLocalizedMessage());
                }
                throw new GFacHandlerException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
            String workingDirectory = jobExecutionContext.getWorkingDir();
            cluster.makeDirectory(workingDirectory);
            if (!jobExecutionContext.getInputDir().equals(workingDirectory)) {
                cluster.makeDirectory(jobExecutionContext.getInputDir());
            }
            if (!jobExecutionContext.getOutputDir().equals(workingDirectory)) {
                cluster.makeDirectory(jobExecutionContext.getOutputDir());
            }
            DataTransferDetails detail = new DataTransferDetails();
            TransferStatus status = new TransferStatus();
            status.setTransferState(TransferState.DIRECTORY_SETUP);
            detail.setTransferStatus(status);
            detail.setTransferDescription("Working directory = " + workingDirectory);
            this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
        }
        catch (Exception e) {
            DataTransferDetails detail = new DataTransferDetails();
            TransferStatus status = new TransferStatus();
            detail.setTransferDescription("Working directory = " + jobExecutionContext.getWorkingDir());
            status.setTransferState(TransferState.FAILED);
            detail.setTransferStatus(status);
            try {
                this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getCause().toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
            }
            catch (Exception e1) {
                throw new GFacHandlerException("Error persisting status", e1, new String[]{e1.getLocalizedMessage()});
            }
            throw new GFacHandlerException("Error executing the Handler: " + GSISSHDirectorySetupHandler.class, (Throwable)e);
        }
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        this.invoke(jobExecutionContext);
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }
}

